/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.phoenixd.mock;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class MockLnServer {
    private static final String BECH32_CHARSET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
    private static final int[] BECH32_GENERATOR = new int[]{996825010, 642813549, 513874426, 1027748829, 705979059};
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private final Map<String, InvoiceInfo> invoices = new ConcurrentHashMap<String, InvoiceInfo>();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2);
    private final HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final int autoSettleDelaySeconds = Integer.parseInt(System.getenv().getOrDefault("PHOENIXD_AUTO_SETTLE_DELAY_SECONDS", "2"));
    private final boolean autopayEnabled = Boolean.parseBoolean(System.getenv().getOrDefault("PHOENIXD_AUTOPAY_ENABLED", "true"));
    private final String webhookBaseUrl = System.getenv().getOrDefault("PHOENIXD_WEBHOOK_BASE_URL", "http://cashu-gateway-rest:8080");
    private HttpServer server;
    private final int port;

    public void start() throws IOException {
        this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
        this.server.createContext("/getlnaddress", this::handleGetLightningAddress);
        this.server.createContext("/paylnaddress", this::handlePayLightningAddress);
        this.server.createContext("/createinvoice", this::handleCreateInvoice);
        this.server.createContext("/getinvoice", this::handleGetInvoice);
        this.server.createContext("/decodeinvoice", this::handleDecodeInvoice);
        this.server.createContext("/payinvoice", this::handlePayInvoice);
        this.server.createContext("/delete", this::handleDelete);
        this.server.createContext("/patch", this::handlePatch);
        this.server.createContext("/mockpay", this::handleMockPay);
        this.server.setExecutor(null);
        this.server.start();
        System.out.println("phoenixd-mock: Started on port " + this.port + " autopay_enabled=" + this.autopayEnabled + " auto_settle_delay=" + this.autoSettleDelaySeconds + "s webhook_url=" + this.webhookBaseUrl);
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop(0);
            this.server = null;
        }
        this.scheduler.shutdownNow();
    }

    private void handleGetLightningAddress(HttpExchange exchange) throws IOException {
        this.writeString(exchange, "\u20bf398ja@strike.me");
    }

    private void handlePayLightningAddress(HttpExchange exchange) throws IOException {
        this.writeJson(exchange, "{\"recipientAmountSat\":10}");
    }

    private void handleCreateInvoice(HttpExchange exchange) throws IOException {
        String body = new String(exchange.getRequestBody().readAllBytes(), StandardCharsets.UTF_8);
        String externalId = null;
        long amountSat = 10L;
        if (body != null && !body.isEmpty()) {
            for (String param : body.split("&")) {
                String[] pair = param.split("=", 2);
                if (pair.length != 2) continue;
                if ("externalId".equals(pair[0])) {
                    String value = URLDecoder.decode(pair[1], StandardCharsets.UTF_8);
                    externalId = value.isEmpty() ? null : value;
                    continue;
                }
                if (!"amountSat".equals(pair[0])) continue;
                try {
                    amountSat = Long.parseLong(pair[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        String invoiceId = Long.toHexString(System.nanoTime());
        String paymentHash = "hash" + invoiceId;
        String bolt11 = this.generateValidBolt11Invoice();
        InvoiceInfo invoiceInfo = new InvoiceInfo(paymentHash, bolt11, amountSat, externalId);
        this.invoices.put(paymentHash, invoiceInfo);
        if (this.autopayEnabled) {
            this.scheduler.schedule(() -> this.autoSettleInvoice(paymentHash), (long)this.autoSettleDelaySeconds, TimeUnit.SECONDS);
            System.out.println("phoenixd-mock: Created invoice payment_hash=" + paymentHash + " external_id=" + externalId + " amount=" + amountSat + " auto_settle_in=" + this.autoSettleDelaySeconds + "s");
        } else {
            System.out.println("phoenixd-mock: Created invoice payment_hash=" + paymentHash + " external_id=" + externalId + " amount=" + amountSat + " autopay=disabled (awaiting external payment or /mockpay)");
        }
        this.writeJson(exchange, "{\"amountSat\":" + amountSat + ",\"paymentHash\":\"" + paymentHash + "\",\"serialized\":\"" + bolt11 + "\"}");
    }

    private void handleGetInvoice(HttpExchange exchange) throws IOException {
        InvoiceInfo invoice;
        String query = exchange.getRequestURI().getQuery();
        String paymentHash = null;
        if (query != null) {
            for (String param : query.split("&")) {
                String[] pair = param.split("=");
                if (pair.length != 2 || !"paymentHash".equals(pair[0])) continue;
                paymentHash = pair[1];
                break;
            }
        }
        if ((invoice = this.invoices.get(paymentHash)) == null) {
            this.writeJson(exchange, "{\"error\":\"Invoice not found\"}");
            return;
        }
        String status = invoice.settled ? "PAID" : "PENDING";
        this.writeJson(exchange, String.format("{\"paymentHash\":\"%s\",\"amountSat\":%d,\"serialized\":\"%s\",\"isPaid\":%b,\"status\":\"%s\"}", invoice.paymentHash, invoice.amountSat, invoice.serialized, invoice.settled, status));
    }

    private String generateValidBolt11Invoice() {
        String hrp = "lnbc10n";
        StringBuilder data = new StringBuilder();
        for (int i = 0; i < 52; ++i) {
            data.append(BECH32_CHARSET.charAt(SECURE_RANDOM.nextInt(BECH32_CHARSET.length())));
        }
        String checksum = this.calculateBech32Checksum(hrp, data.toString());
        return hrp + "1" + String.valueOf(data) + checksum;
    }

    private String calculateBech32Checksum(String hrp, String data) {
        int i;
        int[] values = new int[hrp.length() * 2 + 1 + data.length() + 6];
        int idx = 0;
        for (i = 0; i < hrp.length(); ++i) {
            values[idx++] = hrp.charAt(i) >> 5;
        }
        values[idx++] = 0;
        for (i = 0; i < hrp.length(); ++i) {
            values[idx++] = hrp.charAt(i) & 0x1F;
        }
        for (i = 0; i < data.length(); ++i) {
            values[idx++] = BECH32_CHARSET.indexOf(data.charAt(i));
        }
        for (i = 0; i < 6; ++i) {
            values[idx++] = 0;
        }
        int polymod = this.polymod(values) ^ 1;
        StringBuilder checksum = new StringBuilder();
        for (int i2 = 0; i2 < 6; ++i2) {
            checksum.append(BECH32_CHARSET.charAt(polymod >> 5 * (5 - i2) & 0x1F));
        }
        return checksum.toString();
    }

    private int polymod(int[] values) {
        int chk = 1;
        for (int value : values) {
            int top = chk >> 25;
            chk = (chk & 0x1FFFFFF) << 5 ^ value;
            for (int i = 0; i < 5; ++i) {
                if ((top >> i & 1) == 0) continue;
                chk ^= BECH32_GENERATOR[i];
            }
        }
        return chk;
    }

    private void handleDecodeInvoice(HttpExchange exchange) throws IOException {
        this.writeJson(exchange, "{\"amount\":1000,\"description\":\"1 Blockaccino\"}");
    }

    private void handlePayInvoice(HttpExchange exchange) throws IOException {
        String body = new String(exchange.getRequestBody().readAllBytes(), StandardCharsets.UTF_8);
        String invoice = null;
        if (body != null && !body.isEmpty()) {
            for (String param : body.split("&")) {
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || !"invoice".equals(pair[0])) continue;
                invoice = URLDecoder.decode(pair[1], StandardCharsets.UTF_8);
                break;
            }
        }
        if (invoice == null || invoice.isEmpty()) {
            this.writeJson(exchange, "{\"error\":\"Invoice required\"}");
            return;
        }
        String paymentId = "payment-" + Long.toHexString(System.nanoTime());
        String paymentHash = "hash-" + Long.toHexString(System.nanoTime());
        long amountSat = 10L;
        System.out.println("phoenixd-mock: Paying invoice invoice=" + invoice.substring(0, Math.min(20, invoice.length())) + "... payment_id=" + paymentId);
        this.writeJson(exchange, String.format("{\"recipientAmountSat\":%d,\"paymentId\":\"%s\",\"paymentHash\":\"%s\"}", amountSat, paymentId, paymentHash));
    }

    private void handleDelete(HttpExchange exchange) throws IOException {
        this.writeJson(exchange, "{\"status\":\"deleted\"}");
    }

    private void handlePatch(HttpExchange exchange) throws IOException {
        this.writeJson(exchange, "{\"status\":\"patched\"}");
    }

    private void handleMockPay(HttpExchange exchange) throws IOException {
        String query = exchange.getRequestURI().getQuery();
        String paymentHash = null;
        Long amountSatOverride = null;
        if (query != null) {
            for (String param : query.split("&")) {
                String[] pair = param.split("=");
                if (pair.length != 2) continue;
                if ("paymentHash".equals(pair[0])) {
                    paymentHash = pair[1];
                    continue;
                }
                if (!"amountSat".equals(pair[0])) continue;
                try {
                    amountSatOverride = Long.parseLong(pair[1]);
                }
                catch (NumberFormatException e) {
                    this.writeJsonWithStatus(exchange, 400, "{\"error\":\"Invalid amountSat value\"}");
                    return;
                }
            }
        }
        if (paymentHash == null) {
            this.writeJsonWithStatus(exchange, 400, "{\"error\":\"paymentHash parameter required\"}");
            return;
        }
        InvoiceInfo invoice = this.invoices.get(paymentHash);
        if (invoice == null) {
            this.writeJsonWithStatus(exchange, 404, "{\"error\":\"Invoice not found\",\"paymentHash\":\"" + paymentHash + "\"}");
            return;
        }
        if (invoice.settled) {
            this.writeJson(exchange, "{\"status\":\"already_paid\",\"paymentHash\":\"" + paymentHash + "\"}");
            return;
        }
        long paidAmount = amountSatOverride != null ? amountSatOverride : invoice.amountSat;
        long quotedAmount = invoice.amountSat;
        String paymentType = "exact";
        if (amountSatOverride != null) {
            if (paidAmount > quotedAmount) {
                paymentType = "overpayment";
            } else if (paidAmount < quotedAmount) {
                paymentType = "underpayment (test only - wouldn't happen in production)";
            }
        }
        this.autoSettleInvoice(paymentHash);
        System.out.println("phoenixd-mock: Mock payment received payment_hash=" + paymentHash + " quoted=" + quotedAmount + " paid=" + paidAmount + " type=" + paymentType);
        this.writeJson(exchange, "{\"status\":\"paid\",\"paymentHash\":\"" + paymentHash + "\",\"quotedAmountSat\":" + quotedAmount + ",\"paidAmountSat\":" + paidAmount + ",\"paymentType\":\"" + paymentType.split(" ")[0] + "\"}");
    }

    private void autoSettleInvoice(String paymentHash) {
        InvoiceInfo invoice = this.invoices.get(paymentHash);
        if (invoice == null || invoice.settled) {
            return;
        }
        invoice.settled = true;
        System.out.println("phoenixd-mock: Auto-settling invoice payment_hash=" + paymentHash + " amount=" + invoice.amountSat + " sat");
        this.sendWebhookNotification(invoice);
    }

    private void sendWebhookNotification(InvoiceInfo invoice) {
        try {
            if (invoice.externalId == null) {
                System.err.println("phoenixd-mock: No externalId for invoice payment_hash=" + invoice.paymentHash);
                return;
            }
            String actualQuoteId = this.lookupQuoteIdByInvoiceId(invoice.externalId);
            if (actualQuoteId == null) {
                System.err.println("phoenixd-mock: Could not find quote for invoice_id=" + invoice.externalId);
                return;
            }
            String paymentSearchUrl = this.webhookBaseUrl + "/payment/search/findByQuoteId?quoteId=" + URLEncoder.encode(actualQuoteId, StandardCharsets.UTF_8);
            HttpResponse<String> paymentResponse = this.httpClient.send(HttpRequest.newBuilder().uri(URI.create(paymentSearchUrl)).GET().build(), HttpResponse.BodyHandlers.ofString());
            if (paymentResponse.statusCode() < 200 || paymentResponse.statusCode() >= 300) {
                System.err.println("phoenixd-mock: Payment not found quote_id=" + actualQuoteId + " invoice_id=" + invoice.externalId);
                return;
            }
            String paymentBody = paymentResponse.body();
            JsonNode paymentJson = this.objectMapper.readTree(paymentBody);
            JsonNode linksNode = paymentJson.get("_links");
            if (linksNode == null) {
                System.err.println("phoenixd-mock: _links field not found in payment response");
                return;
            }
            JsonNode selfNode = linksNode.get("self");
            if (selfNode == null) {
                System.err.println("phoenixd-mock: self link not found in payment response");
                return;
            }
            JsonNode hrefNode = selfNode.get("href");
            if (hrefNode == null) {
                System.err.println("phoenixd-mock: href field not found in self link");
                return;
            }
            String paymentUrl = hrefNode.asText();
            String payload = String.format("{\"state\":\"PAID\",\"paidDate\":\"%s\"}", Instant.now());
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(paymentUrl)).header("Content-Type", "application/json").method("PATCH", HttpRequest.BodyPublishers.ofString(payload)).build();
            String finalQuoteId = actualQuoteId;
            ((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
                if (response.statusCode() >= 200 && response.statusCode() < 300) {
                    System.out.println("phoenixd-mock: Payment updated to PAID quote_id=" + finalQuoteId + " invoice_id=" + invoice.externalId + " status=" + response.statusCode());
                } else {
                    System.err.println("phoenixd-mock: Payment update failed quote_id=" + finalQuoteId + " invoice_id=" + invoice.externalId + " status=" + response.statusCode() + " body=" + (String)response.body());
                }
            })).exceptionally(ex -> {
                System.err.println("phoenixd-mock: Payment update exception quote_id=" + finalQuoteId + " invoice_id=" + invoice.externalId + " error=" + ex.getMessage());
                return null;
            });
        }
        catch (Exception e) {
            System.err.println("phoenixd-mock: Failed to update payment invoice_id=" + invoice.externalId + " error=" + e.getMessage());
        }
    }

    private String lookupQuoteIdByInvoiceId(String invoiceId) {
        try {
            JsonNode quoteJson;
            JsonNode quoteIdNode;
            String url = this.webhookBaseUrl + "/quote/search/findByInvoiceId?invoiceId=" + URLEncoder.encode(invoiceId, StandardCharsets.UTF_8);
            HttpResponse<String> response = this.httpClient.send(HttpRequest.newBuilder().uri(URI.create(url)).GET().build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() >= 200 && response.statusCode() < 300 && (quoteIdNode = (quoteJson = this.objectMapper.readTree(response.body())).get("quoteId")) != null) {
                return quoteIdNode.asText();
            }
            System.err.println("phoenixd-mock: Quote not found for invoice_id=" + invoiceId);
            return null;
        }
        catch (Exception e) {
            System.err.println("phoenixd-mock: Failed to lookup quote invoice_id=" + invoiceId + " error=" + e.getMessage());
            return null;
        }
    }

    private void writeJson(HttpExchange exchange, String json) throws IOException {
        this.writeJsonWithStatus(exchange, 200, json);
    }

    private void writeJsonWithStatus(HttpExchange exchange, int statusCode, String json) throws IOException {
        exchange.getResponseHeaders().add("Content-Type", "application/json");
        byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
        exchange.sendResponseHeaders(statusCode, bytes.length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(bytes);
        }
    }

    private void writeString(HttpExchange exchange, String body) throws IOException {
        byte[] bytes = body.getBytes(StandardCharsets.UTF_8);
        exchange.sendResponseHeaders(200, bytes.length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(bytes);
        }
    }

    @Generated
    public MockLnServer(int port) {
        this.port = port;
    }

    private static class InvoiceInfo {
        final String paymentHash;
        final String serialized;
        final long amountSat;
        final String externalId;
        boolean settled;

        InvoiceInfo(String paymentHash, String serialized, long amountSat, String externalId) {
            this.paymentHash = paymentHash;
            this.serialized = serialized;
            this.amountSat = amountSat;
            this.externalId = externalId;
            this.settled = false;
        }
    }
}

