/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.phoenixd.operation;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.phoenixd.common.rest.Operation;
import xyz.tcheeric.phoenixd.common.rest.Request;
import xyz.tcheeric.phoenixd.common.rest.util.Configuration;

public abstract class AbstractOperation
implements Operation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractOperation.class);
    protected HttpRequest httpRequest;
    private String responseBody;
    private String requestData;
    public static final long DEFAULT_TIMEOUT = 5000L;
    private static final String PREFIX = "phoenixd";
    private static final Configuration CONFIG = new Configuration("phoenixd");

    private static String getProperty(String key) {
        return CONFIG.get(key);
    }

    private static long getLongProperty(String key, long defaultValue) {
        Long value = CONFIG.getLong(key, Long.valueOf(defaultValue));
        return value != null ? value : defaultValue;
    }

    private static String ensureScheme(String baseUrl) {
        if (baseUrl == null || baseUrl.isBlank()) {
            log.error("Missing required configuration 'phoenixd.base_url'");
            throw new IllegalArgumentException("phoenixd.base_url is not set");
        }
        String trimmed = baseUrl.trim();
        String lower = trimmed.toLowerCase();
        if (lower.startsWith("http://") || lower.startsWith("https://")) {
            return trimmed;
        }
        if (log.isDebugEnabled()) {
            log.debug("No scheme in base_url '{}', defaulting to http://", (Object)baseUrl);
        }
        return "http://" + trimmed;
    }

    private static URI buildUri(String baseUrl, String path) {
        String normalizedBase = AbstractOperation.ensureScheme(baseUrl);
        String normalizedPath = path == null || path.isEmpty() ? "/" : (path.startsWith("/") ? path : "/" + path);
        return URI.create(normalizedBase).resolve(normalizedPath);
    }

    public AbstractOperation(@NonNull HttpRequest httpRequest) {
        if (httpRequest == null) {
            throw new NullPointerException("httpRequest is marked non-null but is null");
        }
        this.httpRequest = httpRequest;
    }

    public AbstractOperation(@NonNull String method, @NonNull String path, String requestData) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        String username = AbstractOperation.getProperty("username");
        String password = AbstractOperation.getProperty("password");
        String baseUrl = AbstractOperation.getProperty("base_url");
        long timeout = AbstractOperation.getLongProperty("timeout", 5000L);
        String auth = username + ":" + password;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
        this.requestData = requestData;
        HttpRequest.BodyPublisher bodyPublisher = requestData == null ? HttpRequest.BodyPublishers.noBody() : HttpRequest.BodyPublishers.ofString(requestData);
        this.httpRequest = HttpRequest.newBuilder().uri(AbstractOperation.buildUri(baseUrl, path)).header("Authorization", "Basic " + encodedAuth).timeout(Duration.ofMillis(timeout)).method(method, bodyPublisher).build();
        if (log.isDebugEnabled()) {
            log.debug("Prepared HTTP request: method={}, uri={}, timeoutMs={}", new Object[]{method, this.httpRequest.uri(), timeout});
        }
    }

    public AbstractOperation(@NonNull String method, @NonNull String path, @NonNull Request.Param param, String requestData) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        String username = AbstractOperation.getProperty("username");
        String password = AbstractOperation.getProperty("password");
        String baseUrl = AbstractOperation.getProperty("base_url");
        String auth = username + ":" + password;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
        long timeout = AbstractOperation.getLongProperty("timeout", 5000L);
        this.requestData = requestData;
        HttpRequest.BodyPublisher bodyPublisher = requestData == null ? HttpRequest.BodyPublishers.noBody() : HttpRequest.BodyPublishers.ofString(requestData);
        Object resolvedPath = this.replacePathVariables(path, param);
        if (param.getKind() == Request.Param.Kind.QUERY) {
            resolvedPath = (String)resolvedPath + "?" + String.valueOf(param);
        }
        this.httpRequest = HttpRequest.newBuilder().uri(AbstractOperation.buildUri(baseUrl, (String)resolvedPath)).header("Authorization", "Basic " + encodedAuth).timeout(Duration.ofMillis(timeout)).method(method, bodyPublisher).build();
        if (log.isDebugEnabled()) {
            log.debug("Prepared HTTP request: method={}, uri={}, timeoutMs={} (with params)", new Object[]{method, this.httpRequest.uri(), timeout});
        }
    }

    public Operation execute() {
        if (log.isDebugEnabled()) {
            log.debug("Sending HTTP request: {} {}", (Object)this.httpRequest.method(), (Object)this.httpRequest.uri());
        }
        CompletableFuture<HttpResponse<String>> response = HttpClient.newBuilder().build().sendAsync(this.httpRequest, HttpResponse.BodyHandlers.ofString());
        HttpResponse<String> httpResp = response.get();
        this.responseBody = httpResp.body();
        int statusCode = httpResp.statusCode();
        if (log.isDebugEnabled()) {
            log.debug("Received response: status={} uri={}", (Object)statusCode, (Object)this.httpRequest.uri());
        }
        if (statusCode < 200 || statusCode >= 300) {
            String preview = this.responseBody == null ? "" : (this.responseBody.length() > 512 ? this.responseBody.substring(0, 512) + "..." : this.responseBody);
            log.error("HTTP request failed: status={} uri={} bodyPreview={}", new Object[]{statusCode, this.httpRequest.uri(), preview});
            throw new IOException("Failed HTTP request: " + statusCode + " " + preview);
        }
        return this;
    }

    public Operation addHeader(@NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        HttpHeaders headers = this.httpRequest.headers();
        Map<String, List<String>> headersMap = headers.map();
        Map<String, List> newHeadersMap = headersMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        newHeadersMap.put(key, List.of(value));
        String method = this.httpRequest.method();
        HttpRequest.BodyPublisher bodyPublisher = this.httpRequest.bodyPublisher().orElse(HttpRequest.BodyPublishers.noBody());
        HttpRequest newHttpRequest = HttpRequest.newBuilder().uri(this.httpRequest.uri()).timeout(this.httpRequest.timeout().orElse(null)).headers((String[])newHeadersMap.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(v -> Map.entry((String)e.getKey(), v))).flatMap(e -> Stream.of((String)e.getKey(), (String)e.getValue())).toArray(String[]::new)).method(method, bodyPublisher).build();
        this.setHttpRequest(newHttpRequest);
        if (log.isDebugEnabled()) {
            String safeVal = key.equalsIgnoreCase("Authorization") ? "<redacted>" : value;
            log.debug("Updated header: {}={} for {} {}", new Object[]{key, safeVal, this.httpRequest.method(), this.httpRequest.uri()});
        }
        return this;
    }

    public Operation removeHeader(String key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getHeader(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.httpRequest.headers().firstValue(key).orElse(null);
    }

    public String replacePathVariables(String path, Request.Param param) {
        Field[] fields;
        if (param == null || param.getKind() != Request.Param.Kind.PATH) {
            return path;
        }
        for (Field field : fields = param.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object value = field.get(param);
                if (value == null) continue;
                String placeholder = "{" + field.getName() + "}";
                path = path.replace(placeholder, value.toString());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Resolved path with variables: {}", (Object)path);
        }
        return path;
    }

    @Generated
    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    @Generated
    public String getResponseBody() {
        return this.responseBody;
    }

    @Generated
    public String getRequestData() {
        return this.requestData;
    }

    @Generated
    public void setHttpRequest(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    @Generated
    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    @Generated
    public void setRequestData(String requestData) {
        this.requestData = requestData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractOperation)) {
            return false;
        }
        AbstractOperation other = (AbstractOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpRequest this$httpRequest = this.getHttpRequest();
        HttpRequest other$httpRequest = other.getHttpRequest();
        if (this$httpRequest == null ? other$httpRequest != null : !((Object)this$httpRequest).equals(other$httpRequest)) {
            return false;
        }
        String this$responseBody = this.getResponseBody();
        String other$responseBody = other.getResponseBody();
        if (this$responseBody == null ? other$responseBody != null : !this$responseBody.equals(other$responseBody)) {
            return false;
        }
        String this$requestData = this.getRequestData();
        String other$requestData = other.getRequestData();
        return !(this$requestData == null ? other$requestData != null : !this$requestData.equals(other$requestData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractOperation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpRequest $httpRequest = this.getHttpRequest();
        result = result * 59 + ($httpRequest == null ? 43 : ((Object)$httpRequest).hashCode());
        String $responseBody = this.getResponseBody();
        result = result * 59 + ($responseBody == null ? 43 : $responseBody.hashCode());
        String $requestData = this.getRequestData();
        result = result * 59 + ($requestData == null ? 43 : $requestData.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractOperation(httpRequest=" + String.valueOf(this.getHttpRequest()) + ", responseBody=" + this.getResponseBody() + ", requestData=" + this.getRequestData() + ")";
    }
}

