/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.phoenixd.request.impl.rest;

import java.util.regex.Pattern;
import lombok.NonNull;
import xyz.tcheeric.phoenixd.model.param.PayBolt11InvoiceParam;
import xyz.tcheeric.phoenixd.model.param.PayLightningAddressParam;
import xyz.tcheeric.phoenixd.request.impl.rest.BasePayRequest;
import xyz.tcheeric.phoenixd.request.impl.rest.PayBolt11InvoiceRequest;
import xyz.tcheeric.phoenixd.request.impl.rest.PayLightningAddressRequest;

public class PayRequestFactory {
    private static final Pattern BOLT11_PATTERN = Pattern.compile("^(lnbc|lntb|lnsb|lnbcrt)[0-9]*[a-z0-9]+$", 2);

    public static BasePayRequest<?, ?> createPayRequest(@NonNull String request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (request.contains("@")) {
            PayLightningAddressParam param = new PayLightningAddressParam();
            param.setAddress(request);
            return new PayLightningAddressRequest(param);
        }
        if (BOLT11_PATTERN.matcher(request).matches()) {
            PayBolt11InvoiceParam param = new PayBolt11InvoiceParam();
            param.setInvoice(request);
            return new PayBolt11InvoiceRequest(param);
        }
        throw new IllegalArgumentException("Invalid request format");
    }
}

