/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.phoenixd.request.impl.rest;

import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.phoenixd.model.param.PayBolt11InvoiceParam;
import xyz.tcheeric.phoenixd.model.param.PayLightningAddressParam;
import xyz.tcheeric.phoenixd.request.impl.rest.BasePayRequest;
import xyz.tcheeric.phoenixd.request.impl.rest.PayBolt11InvoiceRequest;
import xyz.tcheeric.phoenixd.request.impl.rest.PayLightningAddressRequest;

public class PayRequestFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PayRequestFactory.class);
    private static final Pattern BOLT11_PATTERN = Pattern.compile("^(lnbc|lntb|lnsb|lnbcrt)[0-9]*[a-z0-9]+$", 2);

    public static BasePayRequest<?, ?> createPayRequest(@NonNull String request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Creating pay request for input of length {}", (Object)request.length());
        }
        if (request.contains("@")) {
            PayLightningAddressParam param = new PayLightningAddressParam();
            param.setAddress(request);
            if (log.isDebugEnabled()) {
                log.debug("Detected Lightning Address format");
            }
            return new PayLightningAddressRequest(param);
        }
        if (BOLT11_PATTERN.matcher(request).matches()) {
            PayBolt11InvoiceParam param = new PayBolt11InvoiceParam();
            param.setInvoice(request);
            if (log.isDebugEnabled()) {
                log.debug("Detected BOLT11 invoice format");
            }
            return new PayBolt11InvoiceRequest(param);
        }
        log.warn("Invalid pay request format; input begins with: {}", request.length() > 8 ? request.substring(0, 8) + "..." : request);
        throw new IllegalArgumentException("Invalid request format");
    }
}

