/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.blackbird.deser;

import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.module.blackbird.deser.OptimizedValueInstantiator;
import com.fasterxml.jackson.module.blackbird.util.Unchecked;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class CreatorOptimizer {
    protected final Class<?> _valueClass;
    protected final StdValueInstantiator _originalInstantiator;
    private final MethodHandles.Lookup _lookup;

    public CreatorOptimizer(Class<?> valueClass, MethodHandles.Lookup lookup, StdValueInstantiator orig) {
        this._valueClass = valueClass;
        this._originalInstantiator = orig;
        this._lookup = lookup;
    }

    public ValueInstantiator createOptimized() {
        MethodHandle defaultCreatorHandle;
        MethodHandle argsCreatorHandle;
        if (this._originalInstantiator.canCreateUsingDelegate()) {
            return null;
        }
        if (this._lookup == null) {
            return null;
        }
        AnnotatedWithParams argsCreator = this._originalInstantiator.getWithArgsCreator();
        Function optimizedArgsCreator = null;
        if (argsCreator != null && (argsCreatorHandle = this.directHandle(argsCreator.getAnnotated())) != null) {
            optimizedArgsCreator = Unchecked.supplier(() -> LambdaMetafactory.metafactory(this._lookup, "apply", MethodType.methodType(Function.class, MethodHandle.class), MethodType.methodType(Object.class, Object.class), MethodHandles.lookup().findStatic(CreatorOptimizer.class, "invokeTrampoline", MethodType.methodType(Object.class, MethodHandle.class, Object[].class)), MethodType.methodType(Object.class, Object[].class)).getTarget().invokeExact(argsCreatorHandle.asFixedArity().asSpreader(Object[].class, argsCreatorHandle.type().parameterCount()).asType(MethodType.methodType(Object.class, Object[].class)))).get();
        }
        AnnotatedWithParams defaultCreator = this._originalInstantiator.getDefaultCreator();
        Supplier optimizedFactory = null;
        if (defaultCreator != null && (defaultCreatorHandle = this.directHandle(defaultCreator.getAnnotated())) != null) {
            optimizedFactory = Unchecked.supplier(() -> LambdaMetafactory.metafactory(this._lookup, "get", MethodType.methodType(Supplier.class), MethodType.methodType(Object.class), defaultCreatorHandle, defaultCreatorHandle.type()).getTarget().invokeExact()).get();
        }
        if (optimizedArgsCreator != null || optimizedFactory != null) {
            return new OptimizedValueInstantiator(this._originalInstantiator, optimizedFactory, optimizedArgsCreator);
        }
        return null;
    }

    private MethodHandle directHandle(AnnotatedElement element) {
        return Stream.concat(Stream.of(element).filter(Constructor.class::isInstance).map(Constructor.class::cast).filter(c -> !Modifier.isPrivate(c.getModifiers())).flatMap(t -> {
            try {
                return Stream.of(this._lookup.unreflectConstructor((Constructor<?>)t));
            }
            catch (IllegalAccessException e) {
                return Stream.empty();
            }
        }), Stream.of(element).filter(Method.class::isInstance).map(Method.class::cast).filter(m -> {
            int mods = m.getModifiers();
            return Modifier.isStatic(mods) && !Modifier.isPrivate(mods);
        }).flatMap(t -> {
            try {
                return Stream.of(this._lookup.unreflect((Method)t));
            }
            catch (IllegalAccessException e) {
                return Stream.empty();
            }
        })).findFirst().orElse(null);
    }

    public static Object invokeTrampoline(MethodHandle delegate, Object[] args2) throws Throwable {
        return delegate.invokeExact(args2);
    }
}

