/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.blackbird.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.blackbird.ser.OptimizedBeanPropertyWriter;
import java.util.function.Function;

final class StringPropertyWriter
extends OptimizedBeanPropertyWriter<StringPropertyWriter> {
    private static final long serialVersionUID = 1L;
    private final Function<Object, String> _acc;

    public StringPropertyWriter(BeanPropertyWriter src, Function<Object, String> acc, JsonSerializer<Object> ser) {
        super(src, ser);
        this._acc = acc;
    }

    protected StringPropertyWriter(StringPropertyWriter base, PropertyName name) {
        super(base, name);
        this._acc = base._acc;
    }

    @Override
    protected BeanPropertyWriter _new(PropertyName newName) {
        return new StringPropertyWriter(this, newName);
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new StringPropertyWriter(this, this._acc, ser);
    }

    @Override
    public final void serializeAsField(Object bean2, JsonGenerator gen, SerializerProvider prov) throws Exception {
        String value;
        if (this.broken) {
            this.fallbackWriter.serializeAsField(bean2, gen, prov);
            return;
        }
        try {
            value = this._acc.apply(bean2);
        }
        catch (Throwable t) {
            this._handleProblem(bean2, gen, prov, t, false);
            return;
        }
        if (value == null) {
            if (this._suppressableValue != null && prov.includeFilterSuppressNulls(this._suppressableValue)) {
                return;
            }
            if (this._nullSerializer != null) {
                gen.writeFieldName(this._fastName);
                this._nullSerializer.serialize(null, gen, prov);
            }
            return;
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? value.length() == 0 : this._suppressableValue.equals(value))) {
            return;
        }
        gen.writeFieldName(this._fastName);
        gen.writeString(value);
    }

    @Override
    public final void serializeAsElement(Object bean2, JsonGenerator gen, SerializerProvider prov) throws Exception {
        String value;
        if (this.broken) {
            this.fallbackWriter.serializeAsElement(bean2, gen, prov);
            return;
        }
        try {
            value = this._acc.apply(bean2);
        }
        catch (Throwable t) {
            this._handleProblem(bean2, gen, prov, t, true);
            return;
        }
        if (value == null) {
            if (this._suppressNulls) {
                this.serializeAsPlaceholder(bean2, gen, prov);
            } else {
                prov.defaultSerializeNull(gen);
            }
            return;
        }
        if (this._suppressableValue != null) {
            if (MARKER_FOR_EMPTY == this._suppressableValue) {
                if (value.length() == 0) {
                    this.serializeAsPlaceholder(bean2, gen, prov);
                    return;
                }
            } else if (this._suppressableValue.equals(value)) {
                this.serializeAsPlaceholder(bean2, gen, prov);
                return;
            }
        }
        gen.writeString(value);
    }
}

