/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamingThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String prefix;

    public NamingThreadFactory(String name) {
        this.group = this.getThreadGroup();
        this.prefix = String.join((CharSequence)"-", name, "");
    }

    private ThreadGroup getThreadGroup() {
        SecurityManager security = System.getSecurityManager();
        return security != null ? security.getThreadGroup() : Thread.currentThread().getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable runnable2) {
        Thread thread2 = new Thread(this.group, runnable2, this.createName(), 0L);
        if (thread2.isDaemon()) {
            thread2.setDaemon(false);
        }
        if (thread2.getPriority() != 5) {
            thread2.setPriority(5);
        }
        return thread2;
    }

    private String createName() {
        return this.prefix + this.threadNumber.getAndIncrement();
    }
}

