/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.Tag;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Tags
implements Iterable<Tag> {
    private static final Tag[] EMPTY_TAG_ARRAY = new Tag[0];
    private static final Tags EMPTY = new Tags(EMPTY_TAG_ARRAY, 0);
    private final Tag[] sortedSet;
    private final int length;

    private Tags(Tag[] sortedSet, int length) {
        this.sortedSet = sortedSet;
        this.length = length;
    }

    private static boolean isSortedSet(Tag[] tags, int length) {
        if (length > tags.length) {
            return false;
        }
        for (int i2 = 0; i2 < length - 1; ++i2) {
            int cmp = tags[i2].compareTo(tags[i2 + 1]);
            if (cmp < 0) continue;
            return false;
        }
        return true;
    }

    private static Tags toTags(Tag[] tags) {
        int len = tags.length;
        if (!Tags.isSortedSet(tags, len)) {
            Arrays.sort(tags);
            len = Tags.dedup(tags);
        }
        return new Tags(tags, len);
    }

    private static int dedup(Tag[] tags) {
        int n = tags.length;
        if (n == 0 || n == 1) {
            return n;
        }
        int j = 0;
        for (int i2 = 0; i2 < n - 1; ++i2) {
            if (tags[i2].getKey().equals(tags[i2 + 1].getKey())) continue;
            tags[j++] = tags[i2];
        }
        tags[j++] = tags[n - 1];
        return j;
    }

    private Tags merge(Tags other) {
        if (other.length == 0) {
            return this;
        }
        if (Objects.equals(this, other)) {
            return this;
        }
        Tag[] sortedSet = new Tag[this.length + other.length];
        int sortedIndex = 0;
        int thisIndex = 0;
        int otherIndex = 0;
        while (thisIndex < this.length && otherIndex < other.length) {
            Tag thisTag = this.sortedSet[thisIndex];
            Tag otherTag = other.sortedSet[otherIndex];
            int cmp = thisTag.compareTo(otherTag);
            if (cmp > 0) {
                sortedSet[sortedIndex] = otherTag;
                ++otherIndex;
            } else if (cmp < 0) {
                sortedSet[sortedIndex] = thisTag;
                ++thisIndex;
            } else {
                sortedSet[sortedIndex] = otherTag;
                ++thisIndex;
                ++otherIndex;
            }
            ++sortedIndex;
        }
        int thisRemaining = this.length - thisIndex;
        if (thisRemaining > 0) {
            System.arraycopy(this.sortedSet, thisIndex, sortedSet, sortedIndex, thisRemaining);
            sortedIndex += thisRemaining;
        } else {
            int otherRemaining = other.length - otherIndex;
            if (otherRemaining > 0) {
                System.arraycopy(other.sortedSet, otherIndex, sortedSet, sortedIndex, otherRemaining);
                sortedIndex += otherRemaining;
            }
        }
        return new Tags(sortedSet, sortedIndex);
    }

    public Tags and(String key, String value) {
        return this.and(Tag.of(key, value));
    }

    public Tags and(String ... keyValues) {
        if (Tags.blankVarargs(keyValues)) {
            return this;
        }
        return this.and(Tags.of(keyValues));
    }

    public Tags and(Tag ... tags) {
        if (Tags.blankVarargs(tags)) {
            return this;
        }
        return this.and(Tags.toTags(tags));
    }

    public Tags and(@Nullable Iterable<? extends Tag> tags) {
        if (tags == null || tags == EMPTY || !tags.iterator().hasNext()) {
            return this;
        }
        if (this.length == 0) {
            return Tags.of(tags);
        }
        return this.merge(Tags.of(tags));
    }

    @Override
    public Iterator<Tag> iterator() {
        return new ArrayIterator();
    }

    @Override
    public Spliterator<Tag> spliterator() {
        return Spliterators.spliterator(this.sortedSet, 0, this.length, 1301);
    }

    public Stream<Tag> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public int hashCode() {
        int result = 1;
        for (int i2 = 0; i2 < this.length; ++i2) {
            result = 31 * result + this.sortedSet[i2].hashCode();
        }
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.tagsEqual((Tags)obj);
    }

    private boolean tagsEqual(Tags obj) {
        if (this.sortedSet == obj.sortedSet) {
            return true;
        }
        if (this.length != obj.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.length; ++i2) {
            if (this.sortedSet[i2].equals(obj.sortedSet[i2])) continue;
            return false;
        }
        return true;
    }

    public static Tags concat(@Nullable Iterable<? extends Tag> tags, @Nullable Iterable<? extends Tag> otherTags) {
        return Tags.of(tags).and(otherTags);
    }

    public static Tags concat(@Nullable Iterable<? extends Tag> tags, String ... keyValues) {
        return Tags.of(tags).and(keyValues);
    }

    public static Tags of(@Nullable Iterable<? extends Tag> tags) {
        if (tags == null || tags == EMPTY || !tags.iterator().hasNext()) {
            return Tags.empty();
        }
        if (tags instanceof Tags) {
            return (Tags)tags;
        }
        if (tags instanceof Collection) {
            Collection tagsCollection = (Collection)tags;
            return Tags.toTags(tagsCollection.toArray(EMPTY_TAG_ARRAY));
        }
        return Tags.toTags((Tag[])StreamSupport.stream(tags.spliterator(), false).toArray(Tag[]::new));
    }

    public static Tags of(String key, String value) {
        return new Tags(new Tag[]{Tag.of(key, value)}, 1);
    }

    public static Tags of(String ... keyValues) {
        if (Tags.blankVarargs(keyValues)) {
            return Tags.empty();
        }
        if (keyValues.length % 2 == 1) {
            throw new IllegalArgumentException("size must be even, it is a set of key=value pairs");
        }
        Tag[] tags = new Tag[keyValues.length / 2];
        for (int i2 = 0; i2 < keyValues.length; i2 += 2) {
            tags[i2 / 2] = Tag.of(keyValues[i2], keyValues[i2 + 1]);
        }
        return Tags.toTags(tags);
    }

    private static boolean blankVarargs(@Nullable Object[] args2) {
        return args2 == null || args2.length == 0 || args2.length == 1 && args2[0] == null;
    }

    public static Tags of(Tag ... tags) {
        return Tags.empty().and(tags);
    }

    public static Tags empty() {
        return EMPTY;
    }

    public String toString() {
        return this.stream().map((Function<Tag, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/micrometer/core/instrument/Tag;)Ljava/lang/String;)()).collect(Collectors.joining(",", "[", "]"));
    }

    private class ArrayIterator
    implements Iterator<Tag> {
        private int currentIndex = 0;

        private ArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < Tags.this.length;
        }

        @Override
        public Tag next() {
            return Tags.this.sortedSet[this.currentIndex++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cannot remove items from tags");
        }
    }
}

