/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.distribution;

import io.micrometer.core.instrument.distribution.CountAtBucket;
import java.util.concurrent.atomic.AtomicLongArray;

class FixedBoundaryHistogram {
    final AtomicLongArray values;
    private final double[] buckets;
    private final boolean isCumulativeBucketCounts;

    FixedBoundaryHistogram(double[] buckets, boolean isCumulativeBucketCounts) {
        this.buckets = buckets;
        this.values = new AtomicLongArray(buckets.length);
        this.isCumulativeBucketCounts = isCumulativeBucketCounts;
    }

    double[] getBuckets() {
        return this.buckets;
    }

    void reset() {
        for (int i2 = 0; i2 < this.values.length(); ++i2) {
            this.values.set(i2, 0L);
        }
    }

    void record(long value) {
        int index = this.leastLessThanOrEqualTo(value);
        if (index > -1) {
            this.values.incrementAndGet(index);
        }
    }

    int leastLessThanOrEqualTo(double valueToRecord) {
        int low = 0;
        int high = this.buckets.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            double bucket = this.buckets[mid];
            if (bucket < valueToRecord) {
                low = mid + 1;
                continue;
            }
            if (bucket > valueToRecord) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low < this.buckets.length ? low : -1;
    }

    CountAtBucket[] getCountAtBuckets() {
        CountAtBucket[] countAtBuckets = new CountAtBucket[this.buckets.length];
        long cumulativeCount = 0L;
        for (int i2 = 0; i2 < this.buckets.length; ++i2) {
            long valueAtCurrentBucket = this.values.get(i2);
            countAtBuckets[i2] = this.isCumulativeBucketCounts ? new CountAtBucket(this.buckets[i2], (double)(cumulativeCount += valueAtCurrentBucket)) : new CountAtBucket(this.buckets[i2], (double)valueAtCurrentBucket);
        }
        return countAtBuckets;
    }
}

