/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheusmetrics;

import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.internal.logging.WarnThenDebugLogger;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionCounter;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionTimer;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramSupport;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.internal.DefaultGauge;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.micrometer.core.instrument.internal.DefaultMeter;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.prometheusmetrics.DefaultExemplarSamplerFactory;
import io.micrometer.prometheusmetrics.ExemplarSamplerFactory;
import io.micrometer.prometheusmetrics.MicrometerCollector;
import io.micrometer.prometheusmetrics.PrometheusConfig;
import io.micrometer.prometheusmetrics.PrometheusCounter;
import io.micrometer.prometheusmetrics.PrometheusDistributionSummary;
import io.micrometer.prometheusmetrics.PrometheusNamingConvention;
import io.micrometer.prometheusmetrics.PrometheusTimer;
import io.prometheus.metrics.config.PrometheusProperties;
import io.prometheus.metrics.config.PrometheusPropertiesLoader;
import io.prometheus.metrics.expositionformats.ExpositionFormats;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import io.prometheus.metrics.model.snapshots.ClassicHistogramBuckets;
import io.prometheus.metrics.model.snapshots.CounterSnapshot;
import io.prometheus.metrics.model.snapshots.DataPointSnapshot;
import io.prometheus.metrics.model.snapshots.Exemplar;
import io.prometheus.metrics.model.snapshots.Exemplars;
import io.prometheus.metrics.model.snapshots.GaugeSnapshot;
import io.prometheus.metrics.model.snapshots.HistogramSnapshot;
import io.prometheus.metrics.model.snapshots.InfoSnapshot;
import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.model.snapshots.MetricMetadata;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import io.prometheus.metrics.model.snapshots.Quantile;
import io.prometheus.metrics.model.snapshots.Quantiles;
import io.prometheus.metrics.model.snapshots.SummarySnapshot;
import io.prometheus.metrics.tracer.common.SpanContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class PrometheusMeterRegistry
extends MeterRegistry {
    private static final WarnThenDebugLogger meterRegistrationFailureLogger = new WarnThenDebugLogger(PrometheusMeterRegistry.class);
    private final PrometheusConfig prometheusConfig;
    private final PrometheusRegistry registry;
    private final ExpositionFormats expositionFormats;
    private final ConcurrentMap<String, MicrometerCollector> collectorMap = new ConcurrentHashMap<String, MicrometerCollector>();
    @Nullable
    private final ExemplarSamplerFactory exemplarSamplerFactory;

    public PrometheusMeterRegistry(PrometheusConfig config) {
        this(config, new PrometheusRegistry(), Clock.SYSTEM);
    }

    public PrometheusMeterRegistry(PrometheusConfig config, PrometheusRegistry registry, Clock clock) {
        this(config, registry, clock, null);
    }

    public PrometheusMeterRegistry(PrometheusConfig config, PrometheusRegistry registry, Clock clock, @Nullable SpanContext spanContext) {
        super(clock);
        config.requireValid();
        this.prometheusConfig = config;
        this.registry = registry;
        PrometheusProperties prometheusProperties = config.prometheusProperties() != null ? PrometheusPropertiesLoader.load(config.prometheusProperties()) : PrometheusPropertiesLoader.load();
        this.expositionFormats = ExpositionFormats.init(prometheusProperties.getExporterProperties());
        this.exemplarSamplerFactory = spanContext != null ? new DefaultExemplarSamplerFactory(spanContext, prometheusProperties.getExemplarProperties()) : null;
        this.config().namingConvention(new PrometheusNamingConvention());
        this.config().onMeterRemoved(this::onMeterRemoved);
    }

    private static List<String> tagValues(Meter.Id id) {
        return StreamSupport.stream(id.getTagsAsIterable().spliterator(), false).map(Tag::getValue).collect(Collectors.toList());
    }

    public String scrape() {
        return this.scrape(Format.TEXT_004.getContentType());
    }

    public String scrape(String contentType) {
        ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
        try {
            this.scrape(outputStream2, contentType);
            return outputStream2.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void scrape(OutputStream outputStream2) throws IOException {
        this.scrape(outputStream2, Format.TEXT_004.getContentType());
    }

    public void scrape(OutputStream outputStream2, String contentType) throws IOException {
        this.scrape(outputStream2, contentType, this.registry.scrape());
    }

    private void scrape(OutputStream outputStream2, String contentType, MetricSnapshots snapshots2) throws IOException {
        this.expositionFormats.findWriter(contentType).write(outputStream2, snapshots2);
    }

    public String scrape(String contentType, @Nullable Set<String> includedNames) {
        ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
        try {
            this.scrape((OutputStream)outputStream2, contentType, includedNames);
            return outputStream2.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void scrape(OutputStream outputStream2, String contentType, @Nullable Set<String> includedNames) throws IOException {
        MetricSnapshots snapshots2 = includedNames != null ? this.registry.scrape(includedNames::contains) : this.registry.scrape();
        this.scrape(outputStream2, contentType, snapshots2);
    }

    @Override
    public Counter newCounter(Meter.Id id) {
        PrometheusCounter counter = new PrometheusCounter(id, this.exemplarSamplerFactory);
        long createdTimestampMillis = this.clock.wallTime();
        this.applyToCollector(id, collector -> {
            List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
            collector.add(tagValues, (conventionName, tagKeys) -> Stream.of(new MicrometerCollector.Family(conventionName, family -> new CounterSnapshot(family.metadata, (Collection<CounterSnapshot.CounterDataPointSnapshot>)family.dataPointSnapshots), this.getMetadata(conventionName, id.getDescription()), (DataPointSnapshot[])new CounterSnapshot.CounterDataPointSnapshot[]{new CounterSnapshot.CounterDataPointSnapshot(counter.count(), Labels.of(tagKeys, tagValues), counter.exemplar(), createdTimestampMillis)})));
        });
        return counter;
    }

    @Override
    public DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        PrometheusDistributionSummary summary = new PrometheusDistributionSummary(id, this.clock, distributionStatisticConfig, scale, this.exemplarSamplerFactory);
        long createdTimestampMillis = this.clock.wallTime();
        this.applyToCollector(id, collector -> {
            List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
            collector.add(tagValues, (conventionName, tagKeys) -> {
                Stream.Builder<MicrometerCollector.Family> families = Stream.builder();
                ValueAtPercentile[] percentileValues = summary.takeSnapshot().percentileValues();
                CountAtBucket[] histogramCounts = summary.histogramCounts();
                long count = summary.count();
                double sum = summary.totalAmount();
                if (histogramCounts.length == 0) {
                    Quantiles quantiles = Quantiles.EMPTY;
                    if (percentileValues.length > 0) {
                        ArrayList<Quantile> quantileList = new ArrayList<Quantile>();
                        for (ValueAtPercentile v : percentileValues) {
                            quantileList.add(new Quantile(v.percentile(), v.value()));
                        }
                        quantiles = Quantiles.of(quantileList);
                    }
                    Exemplars exemplars = summary.exemplars();
                    families.add(new MicrometerCollector.Family(conventionName, family -> new SummarySnapshot(family.metadata, (Collection<SummarySnapshot.SummaryDataPointSnapshot>)family.dataPointSnapshots), this.getMetadata(conventionName, id.getDescription()), (DataPointSnapshot[])new SummarySnapshot.SummaryDataPointSnapshot[]{new SummarySnapshot.SummaryDataPointSnapshot(count, sum, quantiles, Labels.of(tagKeys, tagValues), exemplars, createdTimestampMillis)}));
                } else {
                    ArrayList<Double> buckets = new ArrayList<Double>();
                    ArrayList<Double> counts = new ArrayList<Double>();
                    buckets.add(histogramCounts[0].bucket());
                    counts.add(histogramCounts[0].count());
                    for (int i2 = 1; i2 < histogramCounts.length; ++i2) {
                        CountAtBucket countAtBucket = histogramCounts[i2];
                        buckets.add(countAtBucket.bucket());
                        counts.add(countAtBucket.count() - histogramCounts[i2 - 1].count());
                    }
                    if (Double.isFinite(histogramCounts[histogramCounts.length - 1].bucket())) {
                        buckets.add(Double.POSITIVE_INFINITY);
                        double infCount = (double)count - histogramCounts[histogramCounts.length - 1].count();
                        counts.add(infCount >= 0.0 ? infCount : 0.0);
                    }
                    Exemplars exemplars = summary.exemplars();
                    families.add(new MicrometerCollector.Family(conventionName, family -> new HistogramSnapshot(family.metadata, (Collection<HistogramSnapshot.HistogramDataPointSnapshot>)family.dataPointSnapshots), this.getMetadata(conventionName, id.getDescription()), (DataPointSnapshot[])new HistogramSnapshot.HistogramDataPointSnapshot[]{new HistogramSnapshot.HistogramDataPointSnapshot(ClassicHistogramBuckets.of(buckets, counts), sum, Labels.of(tagKeys, tagValues), exemplars, createdTimestampMillis)}));
                }
                families.add(new MicrometerCollector.Family(conventionName + "_max", family -> new GaugeSnapshot(family.metadata, (Collection<GaugeSnapshot.GaugeDataPointSnapshot>)family.dataPointSnapshots), this.getMetadata(conventionName + "_max", id.getDescription()), (DataPointSnapshot[])new GaugeSnapshot.GaugeDataPointSnapshot[]{new GaugeSnapshot.GaugeDataPointSnapshot(summary.max(), Labels.of(tagKeys, tagValues), null)}));
                return families.build();
            });
        });
        return summary;
    }

    @Override
    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        PrometheusTimer timer = new PrometheusTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.exemplarSamplerFactory);
        this.applyToCollector(id, collector -> this.addDistributionStatisticSamples(id, (MicrometerCollector)collector, timer, timer::exemplars, PrometheusMeterRegistry.tagValues(id), false));
        return timer;
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        DefaultGauge gauge = new DefaultGauge(id, obj, valueFunction);
        this.applyToCollector(id, collector -> {
            List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
            if (id.getName().endsWith(".info")) {
                collector.add(tagValues, (conventionName, tagKeys) -> Stream.of(new MicrometerCollector.Family(conventionName, family -> new InfoSnapshot(family.metadata, (Collection<InfoSnapshot.InfoDataPointSnapshot>)family.dataPointSnapshots), this.getMetadata(conventionName, id.getDescription()), (DataPointSnapshot[])new InfoSnapshot.InfoDataPointSnapshot[]{new InfoSnapshot.InfoDataPointSnapshot(Labels.of(tagKeys, tagValues))})));
            } else {
                collector.add(tagValues, (conventionName, tagKeys) -> Stream.of(new MicrometerCollector.Family(conventionName, family -> new GaugeSnapshot(family.metadata, (Collection<GaugeSnapshot.GaugeDataPointSnapshot>)family.dataPointSnapshots), this.getMetadata(conventionName, id.getDescription()), (DataPointSnapshot[])new GaugeSnapshot.GaugeDataPointSnapshot[]{new GaugeSnapshot.GaugeDataPointSnapshot(gauge.value(), Labels.of(tagKeys, tagValues), null)})));
            }
        });
        return gauge;
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        DefaultLongTaskTimer ltt = new DefaultLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig, true);
        this.applyToCollector(id, collector -> this.addDistributionStatisticSamples(id, (MicrometerCollector)collector, ltt, () -> Exemplars.EMPTY, PrometheusMeterRegistry.tagValues(id), true));
        return ltt;
    }

    @Override
    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        CumulativeFunctionTimer ft = new CumulativeFunctionTimer(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
        long createdTimestampMillis = this.clock.wallTime();
        this.applyToCollector(id, collector -> {
            List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
            collector.add(tagValues, (conventionName, tagKeys) -> Stream.of(new MicrometerCollector.Family(conventionName, family -> new SummarySnapshot(family.metadata, (Collection<SummarySnapshot.SummaryDataPointSnapshot>)family.dataPointSnapshots), this.getMetadata(conventionName, id.getDescription()), (DataPointSnapshot[])new SummarySnapshot.SummaryDataPointSnapshot[]{new SummarySnapshot.SummaryDataPointSnapshot((long)ft.count(), ft.totalTime(this.getBaseTimeUnit()), Quantiles.EMPTY, Labels.of(tagKeys, tagValues), null, createdTimestampMillis)})));
        });
        return ft;
    }

    @Override
    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        CumulativeFunctionCounter fc = new CumulativeFunctionCounter(id, obj, countFunction);
        long createdTimestampMillis = this.clock.wallTime();
        this.applyToCollector(id, collector -> {
            List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
            collector.add(tagValues, (conventionName, tagKeys) -> Stream.of(new MicrometerCollector.Family(conventionName, family -> new CounterSnapshot(family.metadata, (Collection<CounterSnapshot.CounterDataPointSnapshot>)family.dataPointSnapshots), this.getMetadata(conventionName, id.getDescription()), (DataPointSnapshot[])new CounterSnapshot.CounterDataPointSnapshot[]{new CounterSnapshot.CounterDataPointSnapshot(fc.count(), Labels.of(tagKeys, tagValues), null, createdTimestampMillis)})));
        });
        return fc;
    }

    @Override
    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        this.applyToCollector(id, collector -> {
            List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
            collector.add(tagValues, (conventionName, tagKeys) -> {
                Stream.Builder<MicrometerCollector.Family<DataPointSnapshot>> families = Stream.builder();
                ArrayList<String> statKeys = new ArrayList<String>(tagKeys);
                statKeys.add("statistic");
                for (Measurement measurement : measurements) {
                    ArrayList<String> statValues = new ArrayList<String>(tagValues);
                    statValues.add(measurement.getStatistic().toString());
                    switch (measurement.getStatistic()) {
                        case TOTAL: 
                        case TOTAL_TIME: {
                            families.add(this.customCounterFamily(id, conventionName, "_sum", Labels.of(statKeys, statValues), measurement.getValue()));
                            break;
                        }
                        case COUNT: {
                            families.add(this.customCounterFamily(id, conventionName, "", Labels.of(statKeys, statValues), measurement.getValue()));
                            break;
                        }
                        case MAX: {
                            families.add(this.customGaugeFamily(id, conventionName, "_max", Labels.of(statKeys, statValues), measurement.getValue()));
                            break;
                        }
                        case VALUE: 
                        case UNKNOWN: {
                            families.add(this.customGaugeFamily(id, conventionName, "_value", Labels.of(statKeys, statValues), measurement.getValue()));
                            break;
                        }
                        case ACTIVE_TASKS: {
                            families.add(this.customGaugeFamily(id, conventionName, "_active_count", Labels.of(statKeys, statValues), measurement.getValue()));
                            break;
                        }
                        case DURATION: {
                            families.add(this.customGaugeFamily(id, conventionName, "_duration_sum", Labels.of(statKeys, statValues), measurement.getValue()));
                        }
                    }
                }
                return families.build();
            });
        });
        return new DefaultMeter(id, type, measurements);
    }

    private MicrometerCollector.Family<CounterSnapshot.CounterDataPointSnapshot> customCounterFamily(Meter.Id id, String conventionName, String suffix, Labels labels, double value) {
        long createdTimestampMillis = this.clock.wallTime();
        return new MicrometerCollector.Family(conventionName + suffix, family -> new CounterSnapshot(family.metadata, (Collection<CounterSnapshot.CounterDataPointSnapshot>)family.dataPointSnapshots), this.getMetadata(conventionName + suffix, id.getDescription()), (DataPointSnapshot[])new CounterSnapshot.CounterDataPointSnapshot[]{new CounterSnapshot.CounterDataPointSnapshot(value, labels, null, createdTimestampMillis)});
    }

    private MicrometerCollector.Family<GaugeSnapshot.GaugeDataPointSnapshot> customGaugeFamily(Meter.Id id, String conventionName, String suffix, Labels labels, double value) {
        return new MicrometerCollector.Family(conventionName + suffix, family -> new GaugeSnapshot(family.metadata, (Collection<GaugeSnapshot.GaugeDataPointSnapshot>)family.dataPointSnapshots), this.getMetadata(conventionName + suffix, id.getDescription()), (DataPointSnapshot[])new GaugeSnapshot.GaugeDataPointSnapshot[]{new GaugeSnapshot.GaugeDataPointSnapshot(value, labels, null)});
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    public PrometheusRegistry getPrometheusRegistry() {
        return this.registry;
    }

    private void addDistributionStatisticSamples(Meter.Id id, MicrometerCollector collector, HistogramSupport histogramSupport, Supplier<Exemplars> exemplarsSupplier, List<String> tagValues, boolean forLongTaskTimer) {
        long createdTimestampMillis = this.clock.wallTime();
        collector.add(tagValues, (conventionName, tagKeys) -> {
            Stream.Builder<MicrometerCollector.Family> families = Stream.builder();
            io.micrometer.core.instrument.distribution.HistogramSnapshot histogramSnapshot = histogramSupport.takeSnapshot();
            ValueAtPercentile[] percentileValues = histogramSnapshot.percentileValues();
            CountAtBucket[] histogramCounts = histogramSnapshot.histogramCounts();
            long count = histogramSnapshot.count();
            double sum = histogramSnapshot.total(this.getBaseTimeUnit());
            if (histogramCounts.length == 0) {
                Quantiles quantiles = Quantiles.EMPTY;
                if (percentileValues.length > 0) {
                    ArrayList<Quantile> quantileList = new ArrayList<Quantile>();
                    for (ValueAtPercentile v : percentileValues) {
                        quantileList.add(new Quantile(v.percentile(), v.value(this.getBaseTimeUnit())));
                    }
                    quantiles = Quantiles.of(quantileList);
                }
                Exemplars exemplars = this.createExemplarsWithScaledValues((Exemplars)exemplarsSupplier.get());
                families.add(new MicrometerCollector.Family(conventionName, family -> new SummarySnapshot(family.metadata, (Collection<SummarySnapshot.SummaryDataPointSnapshot>)family.dataPointSnapshots), this.getMetadata(conventionName, id.getDescription()), (DataPointSnapshot[])new SummarySnapshot.SummaryDataPointSnapshot[]{new SummarySnapshot.SummaryDataPointSnapshot(count, sum, quantiles, Labels.of(tagKeys, tagValues), exemplars, createdTimestampMillis)}));
            } else {
                ArrayList<Double> buckets = new ArrayList<Double>();
                ArrayList<Double> counts = new ArrayList<Double>();
                buckets.add(histogramCounts[0].bucket(this.getBaseTimeUnit()));
                counts.add(histogramCounts[0].count());
                for (int i2 = 1; i2 < histogramCounts.length; ++i2) {
                    CountAtBucket countAtBucket = histogramCounts[i2];
                    buckets.add(countAtBucket.bucket(this.getBaseTimeUnit()));
                    counts.add(countAtBucket.count() - histogramCounts[i2 - 1].count());
                }
                if (Double.isFinite(histogramCounts[histogramCounts.length - 1].bucket())) {
                    buckets.add(Double.POSITIVE_INFINITY);
                    double infCount = (double)count - histogramCounts[histogramCounts.length - 1].count();
                    counts.add(infCount >= 0.0 ? infCount : 0.0);
                }
                Exemplars exemplars = this.createExemplarsWithScaledValues((Exemplars)exemplarsSupplier.get());
                families.add(new MicrometerCollector.Family(conventionName, family -> new HistogramSnapshot(forLongTaskTimer, family.metadata, family.dataPointSnapshots), this.getMetadata(conventionName, id.getDescription()), (DataPointSnapshot[])new HistogramSnapshot.HistogramDataPointSnapshot[]{new HistogramSnapshot.HistogramDataPointSnapshot(ClassicHistogramBuckets.of(buckets, counts), sum, Labels.of(tagKeys, tagValues), exemplars, createdTimestampMillis)}));
            }
            families.add(new MicrometerCollector.Family(conventionName + "_max", family -> new GaugeSnapshot(family.metadata, (Collection<GaugeSnapshot.GaugeDataPointSnapshot>)family.dataPointSnapshots), this.getMetadata(conventionName + "_max", id.getDescription()), (DataPointSnapshot[])new GaugeSnapshot.GaugeDataPointSnapshot[]{new GaugeSnapshot.GaugeDataPointSnapshot(histogramSnapshot.max(this.getBaseTimeUnit()), Labels.of(tagKeys, tagValues), null)}));
            return families.build();
        });
    }

    private Exemplars createExemplarsWithScaledValues(Exemplars exemplars) {
        return Exemplars.of(StreamSupport.stream(exemplars.spliterator(), false).map(exemplar -> this.createExemplarWithNewValue(TimeUtils.convert(exemplar.getValue(), TimeUnit.NANOSECONDS, this.getBaseTimeUnit()), (Exemplar)exemplar)).collect(Collectors.toList()));
    }

    private Exemplar createExemplarWithNewValue(double newValue, Exemplar exemplar) {
        return Exemplar.builder().value(newValue).labels(exemplar.getLabels()).timestampMillis(exemplar.getTimestampMillis()).build();
    }

    private void onMeterRemoved(Meter meter) {
        MicrometerCollector collector = (MicrometerCollector)this.collectorMap.get(this.getConventionName(meter.getId()));
        if (collector != null) {
            collector.remove(PrometheusMeterRegistry.tagValues(meter.getId()));
            if (collector.isEmpty()) {
                this.collectorMap.remove(this.getConventionName(meter.getId()));
                this.getPrometheusRegistry().unregister(collector);
            }
        }
    }

    private MetricMetadata getMetadata(String name, @Nullable String description) {
        String help = this.prometheusConfig.descriptions() && description != null ? description : " ";
        return new MetricMetadata(name, help, null);
    }

    private void applyToCollector(Meter.Id id, Consumer<MicrometerCollector> consumer) {
        this.collectorMap.compute(this.getConventionName(id), (name, existingCollector) -> {
            if (existingCollector == null) {
                MicrometerCollector micrometerCollector = new MicrometerCollector((String)name, id, this.config().namingConvention());
                consumer.accept(micrometerCollector);
                this.registry.register(micrometerCollector);
                return micrometerCollector;
            }
            Meter.Type type = existingCollector.getMeterType();
            if (!type.equals((Object)id.getType())) {
                this.meterRegistrationFailed(id, "Prometheus requires that all meters with the same name have the same type. There is already an existing meter named '" + name + "' that is a " + (Object)((Object)type) + ". The meter you are attempting to register is a " + (Object)((Object)id.getType()) + ".");
                return existingCollector;
            }
            List tagKeys = this.getConventionTags(id).stream().map(Tag::getKey).collect(Collectors.toList());
            if (existingCollector.getTagKeys().equals(tagKeys)) {
                consumer.accept((MicrometerCollector)existingCollector);
                return existingCollector;
            }
            this.meterRegistrationFailed(id, "Prometheus requires that all meters with the same name have the same set of tag keys. There is already an existing meter named '" + this.getConventionName(id) + "' containing tag keys [" + String.join((CharSequence)", ", ((MicrometerCollector)this.collectorMap.get(this.getConventionName(id))).getTagKeys()) + "]. The meter you are attempting to register has keys [" + String.join((CharSequence)", ", tagKeys) + "].");
            return existingCollector;
        });
    }

    @Override
    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.prometheusConfig.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }

    public PrometheusMeterRegistry throwExceptionOnRegistrationFailure() {
        this.config().onMeterRegistrationFailed((id, reason) -> {
            throw new IllegalArgumentException((String)reason);
        });
        return this;
    }

    @Override
    protected void meterRegistrationFailed(Meter.Id id, @Nullable String reason) {
        meterRegistrationFailureLogger.log(() -> PrometheusMeterRegistry.createMeterRegistrationFailureMessage(id, reason));
        super.meterRegistrationFailed(id, reason);
    }

    private static String createMeterRegistrationFailureMessage(Meter.Id id, @Nullable String reason) {
        String message = String.format("The meter (%s) registration has failed", id);
        message = reason != null ? message + ": " + reason : message + ".";
        return message;
    }

    private static enum Format {
        TEXT_004("text/plain; version=0.0.4; charset=utf-8");

        private final String contentType;

        private Format(String contentType) {
            this.contentType = contentType;
        }

        String getContentType() {
            return this.contentType;
        }
    }
}

