/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.marshal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.ProtoEnumInfo;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;

final class JsonSerializer
extends Serializer {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private final JsonGenerator generator;

    JsonSerializer(OutputStream output) throws IOException {
        this(JSON_FACTORY.createGenerator(output));
    }

    JsonSerializer(JsonGenerator generator) {
        this.generator = generator;
    }

    @Override
    protected void writeTraceId(ProtoFieldInfo field, String traceId) throws IOException {
        this.generator.writeStringField(field.getJsonName(), traceId);
    }

    @Override
    protected void writeSpanId(ProtoFieldInfo field, String spanId) throws IOException {
        this.generator.writeStringField(field.getJsonName(), spanId);
    }

    @Override
    public void writeBool(ProtoFieldInfo field, boolean value) throws IOException {
        this.generator.writeBooleanField(field.getJsonName(), value);
    }

    @Override
    protected void writeEnum(ProtoFieldInfo field, ProtoEnumInfo enumValue) throws IOException {
        this.generator.writeNumberField(field.getJsonName(), enumValue.getEnumNumber());
    }

    @Override
    protected void writeUint32(ProtoFieldInfo field, int value) throws IOException {
        this.generator.writeNumberField(field.getJsonName(), value);
    }

    @Override
    protected void writeSInt32(ProtoFieldInfo field, int value) throws IOException {
        this.generator.writeNumberField(field.getJsonName(), value);
    }

    @Override
    protected void writeint32(ProtoFieldInfo field, int value) throws IOException {
        this.generator.writeNumberField(field.getJsonName(), value);
    }

    @Override
    public void writeInt64(ProtoFieldInfo field, long value) throws IOException {
        this.generator.writeStringField(field.getJsonName(), Long.toString(value));
    }

    @Override
    protected void writeFixed64(ProtoFieldInfo field, long value) throws IOException {
        this.generator.writeStringField(field.getJsonName(), Long.toString(value));
    }

    @Override
    protected void writeFixed64Value(long value) throws IOException {
        this.generator.writeString(Long.toString(value));
    }

    @Override
    protected void writeUInt64Value(long value) throws IOException {
        this.generator.writeString(Long.toString(value));
    }

    @Override
    public void writeUInt64(ProtoFieldInfo field, long value) throws IOException {
        this.generator.writeStringField(field.getJsonName(), Long.toString(value));
    }

    @Override
    protected void writeFixed32(ProtoFieldInfo field, int value) throws IOException {
        this.generator.writeNumberField(field.getJsonName(), value);
    }

    @Override
    public void writeDouble(ProtoFieldInfo field, double value) throws IOException {
        this.generator.writeNumberField(field.getJsonName(), value);
    }

    @Override
    protected void writeDoubleValue(double value) throws IOException {
        this.generator.writeNumber(value);
    }

    @Override
    public void writeString(ProtoFieldInfo field, byte[] utf8Bytes) throws IOException {
        this.generator.writeFieldName(field.getJsonName());
        this.generator.writeString(new String(utf8Bytes, StandardCharsets.UTF_8));
    }

    @Override
    public void writeString(ProtoFieldInfo field, String string, int utf8Length, MarshalerContext context) throws IOException {
        this.generator.writeFieldName(field.getJsonName());
        this.generator.writeString(string);
    }

    @Override
    public void writeRepeatedString(ProtoFieldInfo field, byte[][] utf8Bytes) throws IOException {
        this.generator.writeArrayFieldStart(field.getJsonName());
        for (byte[] value : utf8Bytes) {
            this.generator.writeString(new String(value, StandardCharsets.UTF_8));
        }
        this.generator.writeEndArray();
    }

    @Override
    public void writeBytes(ProtoFieldInfo field, byte[] value) throws IOException {
        this.generator.writeBinaryField(field.getJsonName(), value);
    }

    @Override
    public void writeByteBuffer(ProtoFieldInfo field, ByteBuffer value) throws IOException {
        byte[] data = new byte[value.capacity()];
        ((ByteBuffer)value.duplicate().clear()).get(data);
        this.generator.writeBinaryField(field.getJsonName(), data);
    }

    @Override
    protected void writeStartMessage(ProtoFieldInfo field, int protoMessageSize) throws IOException {
        this.generator.writeObjectFieldStart(field.getJsonName());
    }

    @Override
    protected void writeEndMessage() throws IOException {
        this.generator.writeEndObject();
    }

    @Override
    protected void writeStartRepeatedPrimitive(ProtoFieldInfo field, int protoSizePerElement, int numElements) throws IOException {
        this.generator.writeArrayFieldStart(field.getJsonName());
    }

    @Override
    protected void writeEndRepeatedPrimitive() throws IOException {
        this.generator.writeEndArray();
    }

    @Override
    protected void writeStartRepeatedVarint(ProtoFieldInfo field, int payloadSize) throws IOException {
        this.generator.writeArrayFieldStart(field.getJsonName());
    }

    @Override
    protected void writeEndRepeatedVarint() throws IOException {
        this.generator.writeEndArray();
    }

    @Override
    public void serializeRepeatedMessage(ProtoFieldInfo field, Marshaler[] repeatedMessage) throws IOException {
        this.generator.writeArrayFieldStart(field.getJsonName());
        for (Marshaler marshaler : repeatedMessage) {
            this.writeMessageValue(marshaler);
        }
        this.generator.writeEndArray();
    }

    @Override
    public void serializeRepeatedMessage(ProtoFieldInfo field, List<? extends Marshaler> repeatedMessage) throws IOException {
        this.generator.writeArrayFieldStart(field.getJsonName());
        for (Marshaler marshaler : repeatedMessage) {
            this.writeMessageValue(marshaler);
        }
        this.generator.writeEndArray();
    }

    @Override
    public <T> void serializeRepeatedMessageWithContext(ProtoFieldInfo field, List<? extends T> messages, StatelessMarshaler<T> marshaler, MarshalerContext context) throws IOException {
        this.generator.writeArrayFieldStart(field.getJsonName());
        for (int i2 = 0; i2 < messages.size(); ++i2) {
            T message = messages.get(i2);
            this.generator.writeStartObject();
            marshaler.writeTo(this, message, context);
            this.generator.writeEndObject();
        }
        this.generator.writeEndArray();
    }

    @Override
    protected void writeStartRepeated(ProtoFieldInfo field) throws IOException {
        this.generator.writeArrayFieldStart(field.getJsonName());
    }

    @Override
    protected void writeEndRepeated() throws IOException {
        this.generator.writeEndArray();
    }

    @Override
    protected void writeStartRepeatedElement(ProtoFieldInfo field, int protoMessageSize) throws IOException {
        this.generator.writeStartObject();
    }

    @Override
    protected void writeEndRepeatedElement() throws IOException {
        this.generator.writeEndObject();
    }

    void writeMessageValue(Marshaler message) throws IOException {
        this.generator.writeStartObject();
        message.writeTo(this);
        this.generator.writeEndObject();
    }

    @Override
    public void writeSerializedMessage(byte[] protoSerialized, String jsonSerialized) throws IOException {
        this.generator.writeRaw(jsonSerialized);
    }

    @Override
    public void close() throws IOException {
        this.generator.close();
    }
}

