/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.metrics;

import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.otlp.KeyValueMarshaler;
import io.opentelemetry.proto.metrics.v1.internal.Exemplar;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.LongExemplarData;
import java.io.IOException;
import java.util.List;

final class ExemplarMarshaler
extends MarshalerWithSize {
    private final long timeUnixNano;
    private final ExemplarData value;
    private final ProtoFieldInfo valueField;
    private final SpanContext spanContext;
    private final KeyValueMarshaler[] filteredAttributeMarshalers;

    static ExemplarMarshaler[] createRepeated(List<? extends ExemplarData> exemplars) {
        int numExemplars = exemplars.size();
        ExemplarMarshaler[] marshalers = new ExemplarMarshaler[numExemplars];
        for (int i2 = 0; i2 < numExemplars; ++i2) {
            marshalers[i2] = ExemplarMarshaler.create(exemplars.get(i2));
        }
        return marshalers;
    }

    static ExemplarMarshaler create(ExemplarData exemplar) {
        KeyValueMarshaler[] attributeMarshalers = KeyValueMarshaler.createForAttributes(exemplar.getFilteredAttributes());
        return new ExemplarMarshaler(exemplar.getEpochNanos(), exemplar, ExemplarMarshaler.toProtoExemplarValueType(exemplar), exemplar.getSpanContext(), attributeMarshalers);
    }

    private ExemplarMarshaler(long timeUnixNano, ExemplarData value, ProtoFieldInfo valueField, SpanContext spanContext, KeyValueMarshaler[] filteredAttributeMarshalers) {
        super(ExemplarMarshaler.calculateSize(timeUnixNano, valueField, value, spanContext, filteredAttributeMarshalers));
        this.timeUnixNano = timeUnixNano;
        this.value = value;
        this.valueField = valueField;
        this.spanContext = spanContext;
        this.filteredAttributeMarshalers = filteredAttributeMarshalers;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeFixed64(Exemplar.TIME_UNIX_NANO, this.timeUnixNano);
        if (this.valueField == Exemplar.AS_INT) {
            output.serializeFixed64Optional(this.valueField, ((LongExemplarData)this.value).getValue());
        } else {
            output.serializeDoubleOptional(this.valueField, ((DoubleExemplarData)this.value).getValue());
        }
        if (this.spanContext.isValid()) {
            output.serializeSpanId(Exemplar.SPAN_ID, this.spanContext.getSpanId());
            output.serializeTraceId(Exemplar.TRACE_ID, this.spanContext.getTraceId());
        }
        output.serializeRepeatedMessage(Exemplar.FILTERED_ATTRIBUTES, this.filteredAttributeMarshalers);
    }

    private static int calculateSize(long timeUnixNano, ProtoFieldInfo valueField, ExemplarData value, SpanContext spanContext, KeyValueMarshaler[] filteredAttributeMarshalers) {
        int size = 0;
        size += MarshalerUtil.sizeFixed64(Exemplar.TIME_UNIX_NANO, timeUnixNano);
        size = valueField == Exemplar.AS_INT ? (size += MarshalerUtil.sizeFixed64Optional(valueField, ((LongExemplarData)value).getValue())) : (size += MarshalerUtil.sizeDoubleOptional(valueField, ((DoubleExemplarData)value).getValue()));
        if (spanContext.isValid()) {
            size += MarshalerUtil.sizeSpanId(Exemplar.SPAN_ID, spanContext.getSpanId());
            size += MarshalerUtil.sizeTraceId(Exemplar.TRACE_ID, spanContext.getTraceId());
        }
        return size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Exemplar.FILTERED_ATTRIBUTES, (Marshaler[])filteredAttributeMarshalers);
    }

    static ProtoFieldInfo toProtoExemplarValueType(ExemplarData exemplar) {
        if (exemplar instanceof LongExemplarData) {
            return Exemplar.AS_INT;
        }
        assert (exemplar instanceof DoubleExemplarData);
        return Exemplar.AS_DOUBLE;
    }
}

