/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.sender.okhttp.internal;

import io.opentelemetry.api.internal.InstrumentationUtil;
import io.opentelemetry.exporter.internal.RetryUtil;
import io.opentelemetry.exporter.internal.compression.Compressor;
import io.opentelemetry.exporter.internal.grpc.GrpcResponse;
import io.opentelemetry.exporter.internal.grpc.GrpcSender;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.sender.okhttp.internal.GrpcRequestBody;
import io.opentelemetry.exporter.sender.okhttp.internal.OkHttpUtil;
import io.opentelemetry.exporter.sender.okhttp.internal.RetryInterceptor;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.export.RetryPolicy;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionSpec;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;

public final class OkHttpGrpcSender<T extends Marshaler>
implements GrpcSender<T> {
    private static final String GRPC_STATUS = "grpc-status";
    private static final String GRPC_MESSAGE = "grpc-message";
    private final boolean managedExecutor;
    private final OkHttpClient client;
    private final HttpUrl url;
    private final Supplier<Map<String, List<String>>> headersSupplier;
    @Nullable
    private final Compressor compressor;

    public OkHttpGrpcSender(String endpoint, @Nullable Compressor compressor, long timeoutNanos, long connectTimeoutNanos, Supplier<Map<String, List<String>>> headersSupplier, @Nullable RetryPolicy retryPolicy, @Nullable SSLContext sslContext, @Nullable X509TrustManager trustManager, @Nullable ExecutorService executorService) {
        boolean isPlainHttp;
        Dispatcher dispatcher;
        int callTimeoutMillis = (int)Math.min(Duration.ofNanos(timeoutNanos).toMillis(), Integer.MAX_VALUE);
        int connectTimeoutMillis = (int)Math.min(Duration.ofNanos(connectTimeoutNanos).toMillis(), Integer.MAX_VALUE);
        if (executorService == null) {
            dispatcher = OkHttpUtil.newDispatcher();
            this.managedExecutor = true;
        } else {
            dispatcher = new Dispatcher(executorService);
            this.managedExecutor = false;
        }
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().dispatcher(dispatcher).callTimeout(Duration.ofMillis(callTimeoutMillis)).connectTimeout(Duration.ofMillis(connectTimeoutMillis));
        if (retryPolicy != null) {
            clientBuilder.addInterceptor(new RetryInterceptor(retryPolicy, OkHttpGrpcSender::isRetryable));
        }
        if (isPlainHttp = endpoint.startsWith("http://")) {
            clientBuilder.connectionSpecs(Collections.singletonList(ConnectionSpec.CLEARTEXT));
            clientBuilder.protocols(Collections.singletonList(Protocol.H2_PRIOR_KNOWLEDGE));
        } else {
            clientBuilder.protocols(Arrays.asList(Protocol.HTTP_2, Protocol.HTTP_1_1));
            if (sslContext != null && trustManager != null) {
                clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
            }
        }
        this.client = clientBuilder.build();
        this.headersSupplier = headersSupplier;
        this.url = HttpUrl.get(endpoint);
        this.compressor = compressor;
    }

    @Override
    public void send(T request, final Consumer<GrpcResponse> onResponse, final Consumer<Throwable> onError2) {
        Request.Builder requestBuilder = new Request.Builder().url(this.url);
        Map<String, List<String>> headers = this.headersSupplier.get();
        if (headers != null) {
            headers.forEach((key, values2) -> values2.forEach(value -> requestBuilder.addHeader((String)key, (String)value)));
        }
        requestBuilder.addHeader("te", "trailers");
        if (this.compressor != null) {
            requestBuilder.addHeader("grpc-encoding", this.compressor.getEncoding());
        }
        GrpcRequestBody requestBody = new GrpcRequestBody((Marshaler)request, this.compressor);
        requestBuilder.post(requestBody);
        InstrumentationUtil.suppressInstrumentation(() -> this.client.newCall(requestBuilder.build()).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                onError2.accept(e);
            }

            @Override
            public void onResponse(Call call, Response response) {
                int statusCode;
                try {
                    response.body().bytes();
                }
                catch (IOException e) {
                    onError2.accept(new RuntimeException("Could not consume server response", e));
                    return;
                }
                String status = OkHttpGrpcSender.grpcStatus(response);
                String description = OkHttpGrpcSender.grpcMessage(response);
                try {
                    statusCode = Integer.parseInt(status);
                }
                catch (NumberFormatException ex) {
                    statusCode = 2;
                }
                onResponse.accept(GrpcResponse.create(statusCode, description));
            }
        }));
    }

    @Nullable
    private static String grpcStatus(Response response) {
        String grpcStatus = response.header(GRPC_STATUS);
        if (grpcStatus == null) {
            try {
                grpcStatus = response.trailers().get(GRPC_STATUS);
            }
            catch (IOException e) {
                return null;
            }
        }
        return grpcStatus;
    }

    private static String grpcMessage(Response response) {
        String message = response.header(GRPC_MESSAGE);
        if (message == null) {
            try {
                message = response.trailers().get(GRPC_MESSAGE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (message != null) {
            return OkHttpGrpcSender.unescape(message);
        }
        return response.message();
    }

    @Override
    public CompletableResultCode shutdown() {
        this.client.dispatcher().cancelAll();
        if (this.managedExecutor) {
            this.client.dispatcher().executorService().shutdownNow();
        }
        this.client.connectionPool().evictAll();
        return CompletableResultCode.ofSuccess();
    }

    public static boolean isRetryable(Response response) {
        String grpcStatus = response.header(GRPC_STATUS);
        if (grpcStatus == null) {
            return false;
        }
        return RetryUtil.retryableGrpcStatusCodes().contains(grpcStatus);
    }

    private static String unescape(String value) {
        for (int i2 = 0; i2 < value.length(); ++i2) {
            char c = value.charAt(i2);
            if (c >= ' ' && c < '~' && (c != '%' || i2 + 2 >= value.length())) continue;
            return OkHttpGrpcSender.doUnescape(value.getBytes(StandardCharsets.US_ASCII));
        }
        return value;
    }

    private static String doUnescape(byte[] value) {
        ByteBuffer buf = ByteBuffer.allocate(value.length);
        int i2 = 0;
        while (i2 < value.length) {
            if (value[i2] == 37 && i2 + 2 < value.length) {
                try {
                    buf.put((byte)Integer.parseInt(new String(value, i2 + 1, 2, StandardCharsets.UTF_8), 16));
                    i2 += 3;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            buf.put(value[i2]);
            ++i2;
        }
        return new String(buf.array(), 0, buf.position(), StandardCharsets.UTF_8);
    }
}

