/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.data;

import java.util.List;

final class HistogramPointDataValidations {
    private HistogramPointDataValidations() {
    }

    static void validateIsStrictlyIncreasing(List<Double> xs) {
        for (int i2 = 0; i2 < xs.size() - 1; ++i2) {
            if (xs.get(i2).compareTo(xs.get(i2 + 1)) < 0) continue;
            throw new IllegalArgumentException("invalid boundaries: " + xs);
        }
    }

    static void validateFiniteBoundaries(List<Double> boundaries) {
        if (!boundaries.isEmpty() && (boundaries.get(0).isInfinite() || boundaries.get(boundaries.size() - 1).isInfinite())) {
            throw new IllegalArgumentException("invalid boundaries: contains explicit +/-Inf");
        }
    }
}

