/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.exemplar;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCell;
import io.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCellSelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

abstract class FixedSizeExemplarReservoir<T extends ExemplarData>
implements ExemplarReservoir<T> {
    @Nullable
    private ReservoirCell[] storage = null;
    private final ReservoirCellSelector reservoirCellSelector;
    private final BiFunction<ReservoirCell, Attributes, T> mapAndResetCell;
    private final int size;
    private final Clock clock;
    private volatile boolean hasMeasurements = false;

    FixedSizeExemplarReservoir(Clock clock, int size, ReservoirCellSelector reservoirCellSelector, BiFunction<ReservoirCell, Attributes, T> mapAndResetCell) {
        this.size = size;
        this.clock = clock;
        this.reservoirCellSelector = reservoirCellSelector;
        this.mapAndResetCell = mapAndResetCell;
    }

    @Override
    public void offerLongMeasurement(long value, Attributes attributes, Context context) {
        int bucket;
        if (this.storage == null) {
            this.storage = this.initStorage();
        }
        if ((bucket = this.reservoirCellSelector.reservoirCellIndexFor(this.storage, value, attributes, context)) != -1) {
            this.storage[bucket].recordLongMeasurement(value, attributes, context);
            this.hasMeasurements = true;
        }
    }

    @Override
    public void offerDoubleMeasurement(double value, Attributes attributes, Context context) {
        int bucket;
        if (this.storage == null) {
            this.storage = this.initStorage();
        }
        if ((bucket = this.reservoirCellSelector.reservoirCellIndexFor(this.storage, value, attributes, context)) != -1) {
            this.storage[bucket].recordDoubleMeasurement(value, attributes, context);
            this.hasMeasurements = true;
        }
    }

    private ReservoirCell[] initStorage() {
        ReservoirCell[] storage = new ReservoirCell[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            storage[i2] = new ReservoirCell(this.clock);
        }
        return storage;
    }

    @Override
    public List<T> collectAndReset(Attributes pointAttributes) {
        if (!this.hasMeasurements || this.storage == null) {
            return Collections.emptyList();
        }
        ArrayList<ExemplarData> results = new ArrayList<ExemplarData>();
        for (ReservoirCell reservoirCell : this.storage) {
            ExemplarData result = (ExemplarData)this.mapAndResetCell.apply(reservoirCell, pointAttributes);
            if (result == null) continue;
            results.add(result);
        }
        this.reservoirCellSelector.reset();
        this.hasMeasurements = false;
        return Collections.unmodifiableList(results);
    }
}

