/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.model.snapshots;

import io.prometheus.metrics.model.snapshots.ClassicHistogramBucket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public class ClassicHistogramBuckets
implements Iterable<ClassicHistogramBucket> {
    public static final ClassicHistogramBuckets EMPTY = new ClassicHistogramBuckets(new double[0], new long[0]);
    private final double[] upperBounds;
    private final long[] counts;

    private ClassicHistogramBuckets(double[] upperBounds, long[] counts) {
        this.upperBounds = upperBounds;
        this.counts = counts;
    }

    public static ClassicHistogramBuckets of(List<Double> upperBounds, List<? extends Number> counts) {
        double[] upperBoundsCopy = new double[upperBounds.size()];
        for (int i2 = 0; i2 < upperBounds.size(); ++i2) {
            upperBoundsCopy[i2] = upperBounds.get(i2);
        }
        long[] countsCopy = new long[counts.size()];
        for (int i3 = 0; i3 < counts.size(); ++i3) {
            countsCopy[i3] = counts.get(i3).longValue();
        }
        ClassicHistogramBuckets.sortAndValidate(upperBoundsCopy, countsCopy);
        return new ClassicHistogramBuckets(upperBoundsCopy, countsCopy);
    }

    public static ClassicHistogramBuckets of(double[] upperBounds, Number[] counts) {
        double[] upperBoundsCopy = Arrays.copyOf(upperBounds, upperBounds.length);
        long[] countsCopy = new long[counts.length];
        for (int i2 = 0; i2 < counts.length; ++i2) {
            countsCopy[i2] = counts[i2].longValue();
        }
        ClassicHistogramBuckets.sortAndValidate(upperBoundsCopy, countsCopy);
        return new ClassicHistogramBuckets(upperBoundsCopy, countsCopy);
    }

    public static ClassicHistogramBuckets of(double[] upperBounds, long[] counts) {
        double[] upperBoundsCopy = Arrays.copyOf(upperBounds, upperBounds.length);
        long[] countsCopy = Arrays.copyOf(counts, counts.length);
        ClassicHistogramBuckets.sortAndValidate(upperBoundsCopy, countsCopy);
        return new ClassicHistogramBuckets(upperBoundsCopy, countsCopy);
    }

    private static void sortAndValidate(double[] upperBounds, long[] counts) {
        if (upperBounds.length != counts.length) {
            throw new IllegalArgumentException("upperBounds.length == " + upperBounds.length + " but counts.length == " + counts.length + ". Expected the same length.");
        }
        ClassicHistogramBuckets.sort(upperBounds, counts);
        ClassicHistogramBuckets.validate(upperBounds, counts);
    }

    private static void sort(double[] upperBounds, long[] counts) {
        int n = upperBounds.length;
        for (int i2 = 0; i2 < n - 1; ++i2) {
            for (int j = 0; j < n - i2 - 1; ++j) {
                if (!(upperBounds[j] > upperBounds[j + 1])) continue;
                ClassicHistogramBuckets.swap(j, j + 1, upperBounds, counts);
            }
        }
    }

    private static void swap(int i2, int j, double[] upperBounds, long[] counts) {
        double tmpDouble = upperBounds[j];
        upperBounds[j] = upperBounds[i2];
        upperBounds[i2] = tmpDouble;
        long tmpLong = counts[j];
        counts[j] = counts[i2];
        counts[i2] = tmpLong;
    }

    private static void validate(double[] upperBounds, long[] counts) {
        if (upperBounds.length == 0) {
            throw new IllegalArgumentException(ClassicHistogramBuckets.class.getSimpleName() + " cannot be empty. They must contain at least the +Inf bucket.");
        }
        if (upperBounds[upperBounds.length - 1] != Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException(ClassicHistogramBuckets.class.getSimpleName() + " must contain the +Inf bucket.");
        }
        for (int i2 = 0; i2 < upperBounds.length; ++i2) {
            if (Double.isNaN(upperBounds[i2])) {
                throw new IllegalArgumentException("Cannot use NaN as an upper bound in " + ClassicHistogramBuckets.class.getSimpleName());
            }
            if (counts[i2] < 0L) {
                throw new IllegalArgumentException("Counts in " + ClassicHistogramBuckets.class.getSimpleName() + " cannot be negative.");
            }
            if (i2 <= 0 || upperBounds[i2 - 1] != upperBounds[i2]) continue;
            throw new IllegalArgumentException("Duplicate upper bound " + upperBounds[i2]);
        }
    }

    public int size() {
        return this.upperBounds.length;
    }

    public double getUpperBound(int i2) {
        return this.upperBounds[i2];
    }

    public long getCount(int i2) {
        return this.counts[i2];
    }

    public boolean isEmpty() {
        return this.upperBounds.length == 0;
    }

    private List<ClassicHistogramBucket> asList() {
        ArrayList<ClassicHistogramBucket> result = new ArrayList<ClassicHistogramBucket>(this.size());
        for (int i2 = 0; i2 < this.upperBounds.length; ++i2) {
            result.add(new ClassicHistogramBucket(this.upperBounds[i2], this.counts[i2]));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Iterator<ClassicHistogramBucket> iterator() {
        return this.asList().iterator();
    }

    public Stream<ClassicHistogramBucket> stream() {
        return this.asList().stream();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<Double> upperBounds = new ArrayList<Double>();
        private final List<Long> counts = new ArrayList<Long>();

        private Builder() {
        }

        public Builder bucket(double upperBound, long count) {
            this.upperBounds.add(upperBound);
            this.counts.add(count);
            return this;
        }

        public ClassicHistogramBuckets build() {
            return ClassicHistogramBuckets.of(this.upperBounds, this.counts);
        }
    }
}

