/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.StatusCodes;

public class ResponseReasonPhraseAttribute
implements ExchangeAttribute {
    public static final String RESPONSE_REASON_PHRASE = "%{RESPONSE_REASON_PHRASE}";
    public static final ExchangeAttribute INSTANCE = new ResponseReasonPhraseAttribute();

    private ResponseReasonPhraseAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange2) {
        return StatusCodes.getReason(exchange2.getStatusCode());
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange2, String newValue) throws ReadOnlyAttributeException {
        exchange2.setReasonPhrase(newValue);
    }

    public String toString() {
        return RESPONSE_REASON_PHRASE;
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Response reason phrase";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(ResponseReasonPhraseAttribute.RESPONSE_REASON_PHRASE)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

