/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.handlers;

import io.undertow.UndertowLogger;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;

public class AuthenticationConstraintHandler
implements HttpHandler {
    private final HttpHandler next;

    public AuthenticationConstraintHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        if (this.isAuthenticationRequired(exchange2)) {
            SecurityContext context = exchange2.getSecurityContext();
            UndertowLogger.SECURITY_LOGGER.debugf("Setting authentication required for exchange %s", (Object)exchange2);
            context.setAuthenticationRequired();
        }
        this.next.handleRequest(exchange2);
    }

    protected boolean isAuthenticationRequired(HttpServerExchange exchange2) {
        return true;
    }
}

