/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.handlers;

import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Collection;

public class NotificationReceiverHandler
implements HttpHandler {
    private final HttpHandler next;
    private final NotificationReceiver[] receivers;

    public NotificationReceiverHandler(HttpHandler next, Collection<NotificationReceiver> receivers) {
        this.next = next;
        this.receivers = receivers.toArray(new NotificationReceiver[receivers.size()]);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        SecurityContext sc = exchange2.getSecurityContext();
        for (int i2 = 0; i2 < this.receivers.length; ++i2) {
            sc.registerNotificationReceiver(this.receivers[i2]);
        }
        this.next.handleRequest(exchange2);
    }
}

