/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowOptions;
import io.undertow.server.HttpServerExchange;

public final class RequestStatistics {
    private final HttpServerExchange exchange;

    public RequestStatistics(HttpServerExchange exchange2) {
        this.exchange = exchange2;
    }

    public long getBytesSent() {
        return this.exchange.getResponseBytesSent();
    }

    public long getBytesReceived() {
        return this.exchange.getRequestContentLength();
    }

    public long getStartTime() {
        return this.exchange.getRequestStartTime();
    }

    public long getProcessingTime() {
        if (this.exchange.getConnection().getUndertowOptions().get(UndertowOptions.RECORD_REQUEST_START_TIME, false)) {
            return System.nanoTime() - this.exchange.getRequestStartTime();
        }
        return -1L;
    }

    public String getQueryString() {
        return this.exchange.getQueryString();
    }

    public String getUri() {
        return this.exchange.getRequestURI();
    }

    public String getMethod() {
        return this.exchange.getRequestMethod().toString();
    }

    public String getProtocol() {
        return this.exchange.getProtocol().toString();
    }

    public String getRemoteAddress() {
        return this.exchange.getSourceAddress().toString();
    }
}

