/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.server.handlers.HttpUpgradeHandshake;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.wildfly.common.Assert;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.StreamConnection;

public final class ChannelUpgradeHandler
implements HttpHandler {
    private final CopyOnWriteMap<String, List<Holder>> handlers = new CopyOnWriteMap();
    private volatile HttpHandler nonUpgradeHandler = ResponseCodeHandler.HANDLE_404;

    public synchronized void addProtocol(String productString, ChannelListener<? super StreamConnection> openListener, HttpUpgradeHandshake handshake2) {
        this.addProtocol(productString, null, openListener, handshake2);
    }

    public synchronized void addProtocol(String productString, HttpUpgradeListener openListener, HttpUpgradeHandshake handshake2) {
        this.addProtocol(productString, openListener, null, handshake2);
    }

    private synchronized void addProtocol(String productString, HttpUpgradeListener openListener, final ChannelListener<? super StreamConnection> channelListener, HttpUpgradeHandshake handshake2) {
        List<Holder> list;
        Assert.checkNotEmptyParam("productString", productString);
        if (openListener == null && channelListener == null) {
            throw new IllegalArgumentException("openListener and channelListener are null");
        }
        if (openListener == null) {
            openListener = new HttpUpgradeListener(){

                @Override
                public void handleUpgrade(StreamConnection streamConnection, HttpServerExchange exchange2) {
                    ChannelListeners.invokeChannelListener(streamConnection, channelListener);
                }
            };
        }
        if ((list = this.handlers.get(productString)) == null) {
            list = new CopyOnWriteArrayList<Holder>();
            this.handlers.put(productString, list);
        }
        list.add(new Holder(openListener, handshake2, channelListener));
    }

    public void addProtocol(String productString, ChannelListener<? super StreamConnection> openListener) {
        this.addProtocol(productString, openListener, null);
    }

    public void addProtocol(String productString, HttpUpgradeListener openListener) {
        this.addProtocol(productString, openListener, null);
    }

    public synchronized void removeProtocol(String productString) {
        this.handlers.remove(productString);
    }

    public synchronized void removeProtocol(String productString, ChannelListener<? super StreamConnection> openListener) {
        List<Holder> holders = this.handlers.get(productString);
        if (holders == null) {
            return;
        }
        for (Holder holder : holders) {
            if (holder.channelListener != openListener) continue;
            holders.remove(holder);
            break;
        }
        if (holders.isEmpty()) {
            this.handlers.remove(productString);
        }
    }

    public synchronized void removeProtocol(String productString, HttpUpgradeListener upgradeListener) {
        List<Holder> holders = this.handlers.get(productString);
        if (holders == null) {
            return;
        }
        for (Holder holder : holders) {
            if (holder.listener != upgradeListener) continue;
            holders.remove(holder);
            break;
        }
        if (holders.isEmpty()) {
            this.handlers.remove(productString);
        }
    }

    public HttpHandler getNonUpgradeHandler() {
        return this.nonUpgradeHandler;
    }

    public ChannelUpgradeHandler setNonUpgradeHandler(HttpHandler nonUpgradeHandler) {
        Handlers.handlerNotNull(nonUpgradeHandler);
        this.nonUpgradeHandler = nonUpgradeHandler;
        return this;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        HeaderValues upgradeStrings = exchange2.getRequestHeaders().get(Headers.UPGRADE);
        if (upgradeStrings != null && exchange2.getRequestMethod().equals(Methods.GET)) {
            for (String string : upgradeStrings) {
                List<Holder> holders = this.handlers.get(string);
                if (holders == null) continue;
                for (Holder holder : holders) {
                    HttpUpgradeListener listener = holder.listener;
                    if (holder.handshake != null && !holder.handshake.handleUpgrade(exchange2)) continue;
                    exchange2.upgradeChannel(string, listener);
                    exchange2.endExchange();
                    return;
                }
            }
        }
        this.nonUpgradeHandler.handleRequest(exchange2);
    }

    private static final class Holder {
        final HttpUpgradeListener listener;
        final HttpUpgradeHandshake handshake;
        final ChannelListener<? super StreamConnection> channelListener;

        private Holder(HttpUpgradeListener listener, HttpUpgradeHandshake handshake2, ChannelListener<? super StreamConnection> channelListener) {
            this.listener = listener;
            this.handshake = handshake2;
            this.channelListener = channelListener;
        }
    }
}

