/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.Headers;
import java.util.Locale;
import java.util.Map;

public class NameVirtualHostHandler
implements HttpHandler {
    private volatile HttpHandler defaultHandler = ResponseCodeHandler.HANDLE_404;
    private final Map<String, HttpHandler> hosts = new CopyOnWriteMap<String, HttpHandler>();

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        String hostHeader = exchange2.getRequestHeaders().getFirst(Headers.HOST);
        if (hostHeader != null) {
            String host = hostHeader.contains(":") ? hostHeader.substring(0, hostHeader.lastIndexOf(":")) : hostHeader;
            HttpHandler handler = this.hosts.get(host);
            if (handler != null) {
                handler.handleRequest(exchange2);
                return;
            }
            handler = this.hosts.get(host.toLowerCase(Locale.ENGLISH));
            if (handler != null) {
                handler.handleRequest(exchange2);
                return;
            }
        }
        this.defaultHandler.handleRequest(exchange2);
    }

    public HttpHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    public Map<String, HttpHandler> getHosts() {
        return this.hosts;
    }

    public NameVirtualHostHandler setDefaultHandler(HttpHandler defaultHandler) {
        Handlers.handlerNotNull(defaultHandler);
        this.defaultHandler = defaultHandler;
        return this;
    }

    public synchronized NameVirtualHostHandler addHost(String host, HttpHandler handler) {
        Handlers.handlerNotNull(handler);
        this.hosts.put(host.toLowerCase(Locale.ENGLISH), handler);
        return this;
    }

    public synchronized NameVirtualHostHandler removeHost(String host) {
        this.hosts.remove(host.toLowerCase(Locale.ENGLISH));
        return this;
    }
}

