/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.cache;

import io.undertow.UndertowLogger;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.cache.LimitedBufferSlicePool;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xnio.Buffers;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;

public class ResponseCachingStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private final DirectBufferCache.CacheEntry cacheEntry;
    private final long length;
    private long written;

    public ResponseCachingStreamSinkConduit(StreamSinkConduit next, DirectBufferCache.CacheEntry cacheEntry, long length) {
        super(next);
        this.cacheEntry = cacheEntry;
        this.length = length;
        for (LimitedBufferSlicePool.PooledByteBuffer buffer : cacheEntry.buffers()) {
            buffer.getBuffer().clear();
        }
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source2, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer(source2, count, throughBuffer, new ConduitWritableByteChannel(this));
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        ByteBuffer origSrc = src.duplicate();
        int totalWritten = super.write(src);
        if (totalWritten > 0) {
            LimitedBufferSlicePool.PooledByteBuffer[] pooled = this.cacheEntry.buffers();
            ByteBuffer[] buffers = new ByteBuffer[pooled.length];
            for (int i2 = 0; i2 < buffers.length; ++i2) {
                buffers[i2] = pooled[i2].getBuffer();
            }
            origSrc.limit(origSrc.position() + totalWritten);
            this.written += (long)Buffers.copy(buffers, 0, buffers.length, origSrc);
            if (this.written == this.length) {
                for (ByteBuffer buffer : buffers) {
                    buffer.flip();
                }
                if ((long)this.cacheEntry.size() == this.written) {
                    this.cacheEntry.enable();
                } else {
                    UndertowLogger.ROOT_LOGGER.cacheEntryMismatchContent(this.cacheEntry.key(), this.cacheEntry.size(), this.written);
                    this.cacheEntry.disable();
                    this.cacheEntry.dereference();
                }
            }
        }
        return totalWritten;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        ByteBuffer[] origSrc = new ByteBuffer[srcs.length];
        for (int i2 = 0; i2 < srcs.length; ++i2) {
            origSrc[i2] = srcs[i2].duplicate();
        }
        long totalWritten = super.write(srcs, offs, len);
        if (totalWritten > 0L) {
            LimitedBufferSlicePool.PooledByteBuffer[] pooled = this.cacheEntry.buffers();
            ByteBuffer[] buffers = new ByteBuffer[pooled.length];
            for (int i3 = 0; i3 < buffers.length; ++i3) {
                buffers[i3] = pooled[i3].getBuffer();
            }
            long leftToCopy = totalWritten;
            for (int i4 = 0; i4 < len; ++i4) {
                ByteBuffer buf = origSrc[offs + i4];
                if ((long)buf.remaining() > leftToCopy) {
                    buf.limit((int)((long)buf.position() + leftToCopy));
                }
                Buffers.copy(buffers, 0, buffers.length, buf);
                if ((leftToCopy -= (long)buf.remaining()) == 0L) break;
            }
            this.written += totalWritten;
            if (this.written == this.length) {
                for (ByteBuffer buffer : buffers) {
                    buffer.flip();
                }
                if ((long)this.cacheEntry.size() == this.written) {
                    this.cacheEntry.enable();
                } else {
                    UndertowLogger.ROOT_LOGGER.cacheEntryMismatchContent(this.cacheEntry.key(), this.cacheEntry.size(), this.written);
                    this.cacheEntry.disable();
                    this.cacheEntry.dereference();
                }
            }
        }
        return totalWritten;
    }

    @Override
    public void terminateWrites() throws IOException {
        if (this.written != this.length) {
            this.cacheEntry.disable();
            this.cacheEntry.dereference();
        }
        super.terminateWrites();
    }

    @Override
    public void truncateWrites() throws IOException {
        if (this.written != this.length) {
            this.cacheEntry.disable();
            this.cacheEntry.dereference();
        }
        super.truncateWrites();
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic(this, src);
    }
}

