/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.form;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.MalformedMessageException;
import io.undertow.util.MultipartParser;
import io.undertow.util.SameThreadExecutor;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;

public class MultiPartParserDefinition
implements FormParserFactory.ParserDefinition<MultiPartParserDefinition> {
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private static final long MINSIZE = Long.getLong("io.undertow.multipart.minsize", 16384L);
    private Executor executor;
    private Path tempFileLocation;
    private String defaultEncoding = StandardCharsets.ISO_8859_1.displayName();
    private long maxIndividualFileSize = -1L;
    private long fileSizeThreshold;
    private long fieldSizeThreshold = MINSIZE;

    public MultiPartParserDefinition() {
        this.tempFileLocation = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    }

    public MultiPartParserDefinition(Path tempDir) {
        this.tempFileLocation = tempDir;
    }

    @Override
    public FormDataParser create(HttpServerExchange exchange2) {
        String mimeType = exchange2.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        if (mimeType != null && mimeType.startsWith(MULTIPART_FORM_DATA)) {
            String boundary = Headers.extractQuotedValueFromHeader(mimeType, "boundary");
            if (boundary == null) {
                UndertowLogger.REQUEST_LOGGER.debugf("Could not find boundary in multipart request with ContentType: %s, multipart data will not be available", (Object)mimeType);
                return null;
            }
            final MultiPartUploadHandler parser = new MultiPartUploadHandler(exchange2, boundary, this.maxIndividualFileSize, this.fileSizeThreshold, this.defaultEncoding, this.fieldSizeThreshold);
            exchange2.addExchangeCompleteListener(new ExchangeCompletionListener(){

                @Override
                public void exchangeEvent(HttpServerExchange exchange2, ExchangeCompletionListener.NextListener nextListener) {
                    IoUtils.safeClose((Closeable)parser);
                    nextListener.proceed();
                }
            });
            Long sizeLimit = exchange2.getConnection().getUndertowOptions().get(UndertowOptions.MULTIPART_MAX_ENTITY_SIZE);
            if (sizeLimit != null) {
                exchange2.setMaxEntitySize(sizeLimit);
            }
            UndertowLogger.REQUEST_LOGGER.tracef("Created multipart parser for %s", (Object)exchange2);
            return parser;
        }
        return null;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public MultiPartParserDefinition setExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public MultiPartParserDefinition setFieldSizeThreshold(long fieldSizeThreshold) {
        this.fieldSizeThreshold = fieldSizeThreshold;
        return this;
    }

    public Path getTempFileLocation() {
        return this.tempFileLocation;
    }

    public MultiPartParserDefinition setTempFileLocation(Path tempFileLocation) {
        this.tempFileLocation = tempFileLocation;
        return this;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    @Override
    public MultiPartParserDefinition setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
        return this;
    }

    public long getMaxIndividualFileSize() {
        return this.maxIndividualFileSize;
    }

    public void setMaxIndividualFileSize(long maxIndividualFileSize) {
        this.maxIndividualFileSize = maxIndividualFileSize;
    }

    public void setFileSizeThreshold(long fileSizeThreshold) {
        this.fileSizeThreshold = fileSizeThreshold;
    }

    public static class FileTooLargeException
    extends IOException {
        public FileTooLargeException() {
        }

        public FileTooLargeException(String message) {
            super(message);
        }

        public FileTooLargeException(String message, Throwable cause) {
            super(message, cause);
        }

        public FileTooLargeException(Throwable cause) {
            super(cause);
        }
    }

    private final class MultiPartUploadHandler
    implements FormDataParser,
    MultipartParser.PartHandler {
        private final HttpServerExchange exchange;
        private final FormData data;
        private final List<Path> createdFiles = new ArrayList<Path>();
        private final long maxIndividualFileSize;
        private final long fileSizeThreshold;
        private String defaultEncoding;
        private final ByteArrayOutputStream contentBytes = new ByteArrayOutputStream();
        private String currentName;
        private String fileName;
        private Path file;
        private FileChannel fileChannel;
        private HeaderMap headers;
        private HttpHandler handler;
        private long currentFileSize;
        private final MultipartParser.ParseState parser;
        private final long fieldSizeThreshold;

        private MultiPartUploadHandler(HttpServerExchange exchange2, String boundary, long maxIndividualFileSize, long fileSizeThreshold, String defaultEncoding, long fieldSizeThreshold) {
            String value;
            this.exchange = exchange2;
            this.maxIndividualFileSize = maxIndividualFileSize;
            this.defaultEncoding = defaultEncoding;
            this.fileSizeThreshold = fileSizeThreshold;
            this.fieldSizeThreshold = fieldSizeThreshold;
            this.data = new FormData(exchange2.getConnection().getUndertowOptions().get(UndertowOptions.MAX_PARAMETERS, 1000));
            String charset = defaultEncoding;
            String contentType = exchange2.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
            if (contentType != null && (value = Headers.extractQuotedValueFromHeader(contentType, "charset")) != null) {
                charset = value;
            }
            this.parser = MultipartParser.beginParse(exchange2.getConnection().getByteBufferPool(), this, boundary.getBytes(StandardCharsets.US_ASCII), charset);
        }

        @Override
        public void parse(HttpHandler handler) throws Exception {
            if (this.exchange.getAttachment(FORM_DATA) != null) {
                handler.handleRequest(this.exchange);
                return;
            }
            this.handler = handler;
            StreamSourceChannel requestChannel = this.exchange.getRequestChannel();
            if (requestChannel == null) {
                throw new IOException(UndertowMessages.MESSAGES.requestChannelAlreadyProvided());
            }
            if (MultiPartParserDefinition.this.executor == null) {
                this.exchange.dispatch(new NonBlockingParseTask(this.exchange.getConnection().getWorker(), requestChannel));
            } else {
                this.exchange.dispatch(MultiPartParserDefinition.this.executor, new NonBlockingParseTask(MultiPartParserDefinition.this.executor, requestChannel));
            }
        }

        @Override
        public FormData parseBlocking() throws IOException {
            block13: {
                FormData existing = (FormData)this.exchange.getAttachment(FORM_DATA);
                if (existing != null) {
                    return existing;
                }
                InputStream inputStream2 = this.exchange.getInputStream();
                if (inputStream2 == null) {
                    throw new IOException(UndertowMessages.MESSAGES.requestChannelAlreadyProvided());
                }
                try (PooledByteBuffer pooled = this.exchange.getConnection().getByteBufferPool().getArrayBackedPool().allocate();){
                    if (pooled != null) {
                        ByteBuffer buf = pooled.getBuffer();
                        while (true) {
                            buf.clear();
                            int c = inputStream2.read(buf.array(), buf.arrayOffset(), buf.remaining());
                            if (c == -1) {
                                if (this.parser.isComplete()) break;
                                throw UndertowMessages.MESSAGES.connectionTerminatedReadingMultiPartData();
                            }
                            if (c == 0) continue;
                            buf.limit(c);
                            this.parser.parse(buf);
                        }
                        this.exchange.putAttachment(FORM_DATA, this.data);
                        break block13;
                    }
                    throw UndertowMessages.MESSAGES.failedToAllocateResource();
                }
                catch (MalformedMessageException e) {
                    throw new IOException(e);
                }
            }
            return (FormData)this.exchange.getAttachment(FORM_DATA);
        }

        @Override
        public void beginPart(HeaderMap headers) {
            this.currentFileSize = 0L;
            this.headers = headers;
            String disposition = headers.getFirst(Headers.CONTENT_DISPOSITION);
            if (disposition != null && disposition.startsWith("form-data")) {
                this.currentName = Headers.extractQuotedValueFromHeader(disposition, "name");
                this.fileName = Headers.extractQuotedValueFromHeaderWithEncoding(disposition, "filename");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Path createFile() throws IOException {
            if (MultiPartParserDefinition.this.tempFileLocation != null) {
                FileAttribute[] emptyFA = new FileAttribute[]{};
                LinkOption[] emptyLO = new LinkOption[]{};
                Path normalized = MultiPartParserDefinition.this.tempFileLocation.normalize();
                if (!Files.exists(normalized, new LinkOption[0])) {
                    int pathElementsCount = normalized.getNameCount();
                    Path tmp = normalized;
                    LinkedList<Path> dirsToGuard = new LinkedList<Path>();
                    for (int i2 = 0; i2 < pathElementsCount; ++i2) {
                        if (Files.exists(tmp, emptyLO)) {
                            if (Files.isDirectory(tmp, emptyLO)) break;
                            throw UndertowMessages.MESSAGES.pathElementIsRegularFile(tmp);
                        }
                        dirsToGuard.addFirst(tmp);
                        tmp = tmp.getParent();
                    }
                    try {
                        Files.createDirectories(normalized, emptyFA);
                    }
                    finally {
                        for (Path p : dirsToGuard) {
                            try {
                                p.toFile().deleteOnExit();
                            }
                            catch (Exception e) {
                                break;
                            }
                        }
                    }
                } else if (!Files.isDirectory(normalized, emptyLO)) {
                    throw new IOException(UndertowMessages.MESSAGES.pathNotADirectory(normalized));
                }
                this.file = Files.createTempFile(normalized, "undertow", "upload", new FileAttribute[0]);
            } else {
                this.file = Files.createTempFile("undertow", "upload", new FileAttribute[0]);
            }
            return this.file;
        }

        @Override
        public void data(ByteBuffer buffer) throws IOException {
            this.currentFileSize += (long)buffer.remaining();
            if (this.maxIndividualFileSize > 0L && this.currentFileSize > this.maxIndividualFileSize) {
                throw UndertowMessages.MESSAGES.maxFileSizeExceeded(this.maxIndividualFileSize);
            }
            if (this.file == null && this.fileSizeThreshold < this.currentFileSize && (this.fileName != null || this.currentFileSize > this.fieldSizeThreshold)) {
                try {
                    this.createdFiles.add(this.createFile());
                    FileOutputStream fileOutputStream = new FileOutputStream(this.file.toFile());
                    this.contentBytes.writeTo(fileOutputStream);
                    this.fileChannel = fileOutputStream.getChannel();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.file == null) {
                while (buffer.hasRemaining()) {
                    this.contentBytes.write(buffer.get());
                }
            } else {
                this.fileChannel.write(buffer);
            }
        }

        @Override
        public void endPart() {
            if (this.file != null) {
                if (this.fileName != null) {
                    this.data.add(this.currentName, this.file, this.fileName, this.headers);
                } else {
                    this.data.add(this.currentName, this.file, null, this.headers, true, this.getCharset());
                }
                this.file = null;
                this.contentBytes.reset();
                try {
                    this.fileChannel.close();
                    this.fileChannel = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.fileName != null) {
                this.data.add(this.currentName, Arrays.copyOf(this.contentBytes.toByteArray(), this.contentBytes.size()), this.fileName, this.headers);
                this.contentBytes.reset();
            } else {
                try {
                    String charset = this.getCharset();
                    this.data.add(this.currentName, new String(this.contentBytes.toByteArray(), charset), charset, this.headers);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                this.contentBytes.reset();
            }
        }

        private String getCharset() {
            String cs;
            String charset = this.defaultEncoding;
            String contentType = this.headers.getFirst(Headers.CONTENT_TYPE);
            if (contentType != null && (cs = Headers.extractQuotedValueFromHeader(contentType, "charset")) != null) {
                charset = cs;
            }
            return charset;
        }

        public List<Path> getCreatedFiles() {
            return this.createdFiles;
        }

        @Override
        public void close() throws IOException {
            IoUtils.safeClose((Closeable)this.fileChannel);
            final ArrayList<Path> files = new ArrayList<Path>(this.getCreatedFiles());
            this.exchange.getConnection().getWorker().execute(new Runnable(){

                @Override
                public void run() {
                    for (Path file : files) {
                        if (!Files.exists(file, new LinkOption[0])) continue;
                        try {
                            Files.delete(file);
                        }
                        catch (NoSuchFileException noSuchFileException) {
                        }
                        catch (IOException e) {
                            UndertowLogger.REQUEST_LOGGER.cannotRemoveUploadedFile(file);
                        }
                    }
                    files.clear();
                }
            });
        }

        @Override
        public void setCharacterEncoding(String encoding) {
            this.defaultEncoding = encoding;
            this.parser.setCharacterEncoding(encoding);
        }

        private final class NonBlockingParseTask
        implements Runnable {
            private final Executor executor;
            private final StreamSourceChannel requestChannel;

            private NonBlockingParseTask(Executor executor, StreamSourceChannel requestChannel) {
                this.executor = executor;
                this.requestChannel = requestChannel;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    FormData existing = MultiPartUploadHandler.this.exchange.getAttachment(FormDataParser.FORM_DATA);
                    if (existing != null) {
                        MultiPartUploadHandler.this.exchange.dispatch(SameThreadExecutor.INSTANCE, MultiPartUploadHandler.this.handler);
                        return;
                    }
                    try (PooledByteBuffer pooled = MultiPartUploadHandler.this.exchange.getConnection().getByteBufferPool().allocate();){
                        while (true) {
                            int c;
                            if ((c = this.requestChannel.read(pooled.getBuffer())) == 0) {
                                this.requestChannel.getReadSetter().set((ChannelListener<? extends StreamSourceChannel>)new ChannelListener<StreamSourceChannel>(){

                                    @Override
                                    public void handleEvent(StreamSourceChannel channel) {
                                        channel.suspendReads();
                                        NonBlockingParseTask.this.executor.execute(NonBlockingParseTask.this);
                                    }
                                });
                                this.requestChannel.resumeReads();
                                return;
                            }
                            if (c == -1) {
                                if (MultiPartUploadHandler.this.parser.isComplete()) {
                                    MultiPartUploadHandler.this.exchange.putAttachment(FormDataParser.FORM_DATA, MultiPartUploadHandler.this.data);
                                    MultiPartUploadHandler.this.exchange.dispatch(SameThreadExecutor.INSTANCE, MultiPartUploadHandler.this.handler);
                                    return;
                                }
                                UndertowLogger.REQUEST_IO_LOGGER.ioException(UndertowMessages.MESSAGES.connectionTerminatedReadingMultiPartData());
                                MultiPartUploadHandler.this.exchange.setStatusCode(500);
                                MultiPartUploadHandler.this.exchange.endExchange();
                                return;
                            }
                            pooled.getBuffer().flip();
                            MultiPartUploadHandler.this.parser.parse(pooled.getBuffer());
                            pooled.getBuffer().compact();
                            continue;
                            break;
                        }
                    }
                }
                catch (Throwable e) {
                    UndertowLogger.REQUEST_IO_LOGGER.debug("Exception parsing data", e);
                    MultiPartUploadHandler.this.exchange.setStatusCode(500);
                    MultiPartUploadHandler.this.exchange.endExchange();
                }
            }
        }
    }
}

