/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowLogger;
import io.undertow.io.IoCallback;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.server.handlers.cache.ResponseCache;
import io.undertow.server.handlers.encoding.ContentEncodedResource;
import io.undertow.server.handlers.encoding.ContentEncodedResourceManager;
import io.undertow.server.handlers.resource.DefaultResourceSupplier;
import io.undertow.server.handlers.resource.DirectoryUtils;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.RangeAwareResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.ResourceSupplier;
import io.undertow.util.ByteRange;
import io.undertow.util.CanonicalPathUtils;
import io.undertow.util.DateUtils;
import io.undertow.util.ETag;
import io.undertow.util.ETagUtils;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.MimeMappings;
import io.undertow.util.RedirectBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public class ResourceHandler
implements HttpHandler {
    private static final Set<HttpString> KNOWN_METHODS = new HashSet<HttpString>();
    private final List<String> welcomeFiles = new CopyOnWriteArrayList<String>(new String[]{"index.html", "index.htm", "default.html", "default.htm"});
    private volatile boolean directoryListingEnabled = false;
    private volatile boolean canonicalizePaths = true;
    private volatile MimeMappings mimeMappings = MimeMappings.DEFAULT;
    private volatile Predicate cachable = Predicates.truePredicate();
    private volatile Predicate allowed = Predicates.truePredicate();
    private volatile ResourceSupplier resourceSupplier;
    private volatile ResourceManager resourceManager;
    private volatile Integer cacheTime;
    private volatile ContentEncodedResourceManager contentEncodedResourceManager;
    private final HttpHandler next;

    public ResourceHandler(ResourceManager resourceSupplier) {
        this(resourceSupplier, (HttpHandler)ResponseCodeHandler.HANDLE_404);
    }

    public ResourceHandler(ResourceManager resourceManager, HttpHandler next) {
        this.resourceSupplier = new DefaultResourceSupplier(resourceManager);
        this.resourceManager = resourceManager;
        this.next = next;
    }

    public ResourceHandler(ResourceSupplier resourceSupplier) {
        this(resourceSupplier, (HttpHandler)ResponseCodeHandler.HANDLE_404);
    }

    public ResourceHandler(ResourceSupplier resourceManager, HttpHandler next) {
        this.resourceSupplier = resourceManager;
        this.next = next;
    }

    @Deprecated
    public ResourceHandler() {
        this.next = ResponseCodeHandler.HANDLE_404;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        if (exchange2.getRequestMethod().equals(Methods.GET) || exchange2.getRequestMethod().equals(Methods.POST)) {
            this.serveResource(exchange2, true);
        } else if (exchange2.getRequestMethod().equals(Methods.HEAD)) {
            this.serveResource(exchange2, false);
        } else {
            if (KNOWN_METHODS.contains(exchange2.getRequestMethod())) {
                exchange2.setStatusCode(405);
                exchange2.getResponseHeaders().add(Headers.ALLOW, String.join((CharSequence)", ", "GET", "HEAD", "POST"));
            } else {
                exchange2.setStatusCode(501);
            }
            exchange2.endExchange();
        }
    }

    private void serveResource(HttpServerExchange exchange2, final boolean sendContent) throws Exception {
        if (this.directoryListingEnabled && DirectoryUtils.sendRequestedBlobs(exchange2)) {
            return;
        }
        if (!this.allowed.resolve(exchange2)) {
            exchange2.setStatusCode(403);
            exchange2.endExchange();
            return;
        }
        ResponseCache cache = exchange2.getAttachment(ResponseCache.ATTACHMENT_KEY);
        boolean cachable = this.cachable.resolve(exchange2);
        if (cachable && this.cacheTime != null) {
            exchange2.getResponseHeaders().put(Headers.CACHE_CONTROL, "public, max-age=" + this.cacheTime);
            long date = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.cacheTime.intValue());
            String dateHeader = DateUtils.toDateString(new Date(date));
            exchange2.getResponseHeaders().put(Headers.EXPIRES, dateHeader);
        }
        if (cache != null && cachable && cache.tryServeResponse()) {
            return;
        }
        HttpHandler dispatchTask = new HttpHandler(){

            @Override
            public void handleRequest(HttpServerExchange exchange2) throws Exception {
                Resource resource = null;
                try {
                    if (File.separatorChar == '/' || !exchange2.getRelativePath().contains(File.separator)) {
                        resource = ResourceHandler.this.resourceSupplier.getResource(exchange2, ResourceHandler.this.canonicalize(exchange2.getRelativePath()));
                    }
                }
                catch (IOException e) {
                    ResourceHandler.this.clearCacheHeaders(exchange2);
                    UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                    exchange2.setStatusCode(500);
                    exchange2.endExchange();
                    return;
                }
                if (resource == null) {
                    ResourceHandler.this.clearCacheHeaders(exchange2);
                    ResourceHandler.this.next.handleRequest(exchange2);
                    return;
                }
                if (resource.isDirectory()) {
                    Resource indexResource;
                    try {
                        indexResource = ResourceHandler.this.getIndexFiles(exchange2, ResourceHandler.this.resourceSupplier, resource.getPath(), ResourceHandler.this.welcomeFiles);
                    }
                    catch (IOException e) {
                        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                        exchange2.setStatusCode(500);
                        exchange2.endExchange();
                        return;
                    }
                    if (indexResource == null) {
                        if (ResourceHandler.this.directoryListingEnabled) {
                            DirectoryUtils.renderDirectoryListing(exchange2, resource);
                            return;
                        }
                        exchange2.setStatusCode(403);
                        exchange2.endExchange();
                        return;
                    }
                    if (!exchange2.getRequestPath().endsWith("/")) {
                        exchange2.setStatusCode(302);
                        exchange2.getResponseHeaders().put(Headers.LOCATION, RedirectBuilder.redirect(exchange2, exchange2.getRelativePath() + "/", true));
                        exchange2.endExchange();
                        return;
                    }
                    resource = indexResource;
                } else if (exchange2.getRelativePath().endsWith("/")) {
                    exchange2.setStatusCode(404);
                    exchange2.endExchange();
                    return;
                }
                ETag etag = resource.getETag();
                Date lastModified = resource.getLastModified();
                if (!ETagUtils.handleIfMatch(exchange2, etag, false) || !DateUtils.handleIfUnmodifiedSince(exchange2, lastModified)) {
                    exchange2.setStatusCode(412);
                    exchange2.endExchange();
                    return;
                }
                if (!ETagUtils.handleIfNoneMatch(exchange2, etag, true) || !DateUtils.handleIfModifiedSince(exchange2, lastModified)) {
                    exchange2.setStatusCode(304);
                    exchange2.endExchange();
                    return;
                }
                ContentEncodedResourceManager contentEncodedResourceManager = ResourceHandler.this.contentEncodedResourceManager;
                Long contentLength = resource.getContentLength();
                if (contentLength != null && !exchange2.getResponseHeaders().contains(Headers.TRANSFER_ENCODING)) {
                    exchange2.setResponseContentLength(contentLength);
                }
                ByteRange.RangeResponseResult rangeResponse = null;
                long start = -1L;
                long end = -1L;
                if (resource instanceof RangeAwareResource && ((RangeAwareResource)resource).isRangeSupported() && contentLength != null && contentEncodedResourceManager == null) {
                    exchange2.getResponseHeaders().put(Headers.ACCEPT_RANGES, "bytes");
                    ByteRange range = ByteRange.parse(exchange2.getRequestHeaders().getFirst(Headers.RANGE));
                    if (range != null && range.getRanges() == 1 && resource.getContentLength() != null && (rangeResponse = range.getResponseResult(resource.getContentLength(), exchange2.getRequestHeaders().getFirst(Headers.IF_RANGE), resource.getLastModified(), resource.getETag() == null ? null : resource.getETag().getTag())) != null) {
                        start = rangeResponse.getStart();
                        end = rangeResponse.getEnd();
                        exchange2.setStatusCode(rangeResponse.getStatusCode());
                        exchange2.getResponseHeaders().put(Headers.CONTENT_RANGE, rangeResponse.getContentRange());
                        long length = rangeResponse.getContentLength();
                        exchange2.setResponseContentLength(length);
                        if (rangeResponse.getStatusCode() == 416) {
                            return;
                        }
                    }
                }
                if (!exchange2.getResponseHeaders().contains(Headers.CONTENT_TYPE)) {
                    String contentType = resource.getContentType(ResourceHandler.this.mimeMappings);
                    if (contentType != null) {
                        exchange2.getResponseHeaders().put(Headers.CONTENT_TYPE, contentType);
                    } else {
                        exchange2.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/octet-stream");
                    }
                }
                if (lastModified != null) {
                    exchange2.getResponseHeaders().put(Headers.LAST_MODIFIED, resource.getLastModifiedString());
                }
                if (etag != null) {
                    exchange2.getResponseHeaders().put(Headers.ETAG, etag.toString());
                }
                if (contentEncodedResourceManager != null) {
                    try {
                        ContentEncodedResource encoded = contentEncodedResourceManager.getResource(resource, exchange2);
                        if (encoded != null) {
                            exchange2.getResponseHeaders().put(Headers.CONTENT_ENCODING, encoded.getContentEncoding());
                            exchange2.getResponseHeaders().put(Headers.CONTENT_LENGTH, encoded.getResource().getContentLength());
                            encoded.getResource().serve(exchange2.getResponseSender(), exchange2, IoCallback.END_EXCHANGE);
                            return;
                        }
                    }
                    catch (IOException e) {
                        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                        exchange2.setStatusCode(500);
                        exchange2.endExchange();
                        return;
                    }
                }
                if (!sendContent) {
                    exchange2.endExchange();
                } else if (rangeResponse != null) {
                    ((RangeAwareResource)resource).serveRange(exchange2.getResponseSender(), exchange2, start, end, IoCallback.END_EXCHANGE);
                } else {
                    resource.serve(exchange2.getResponseSender(), exchange2, IoCallback.END_EXCHANGE);
                }
            }
        };
        if (exchange2.isInIoThread()) {
            exchange2.dispatch(dispatchTask);
        } else {
            dispatchTask.handleRequest(exchange2);
        }
    }

    private void clearCacheHeaders(HttpServerExchange exchange2) {
        exchange2.getResponseHeaders().remove(Headers.CACHE_CONTROL);
        exchange2.getResponseHeaders().remove(Headers.EXPIRES);
    }

    private Resource getIndexFiles(HttpServerExchange exchange2, ResourceSupplier resourceManager, String base, List<String> possible) throws IOException {
        Object realBase = base.endsWith("/") ? base : base + "/";
        for (String possibility : possible) {
            Resource index = resourceManager.getResource(exchange2, this.canonicalize((String)realBase + possibility));
            if (index == null) continue;
            return index;
        }
        return null;
    }

    private String canonicalize(String s) {
        if (this.canonicalizePaths) {
            return CanonicalPathUtils.canonicalize(s);
        }
        return s;
    }

    public boolean isDirectoryListingEnabled() {
        return this.directoryListingEnabled;
    }

    public ResourceHandler setDirectoryListingEnabled(boolean directoryListingEnabled) {
        this.directoryListingEnabled = directoryListingEnabled;
        return this;
    }

    public ResourceHandler addWelcomeFiles(String ... files) {
        this.welcomeFiles.addAll(Arrays.asList(files));
        return this;
    }

    public ResourceHandler setWelcomeFiles(String ... files) {
        this.welcomeFiles.clear();
        this.welcomeFiles.addAll(Arrays.asList(files));
        return this;
    }

    public MimeMappings getMimeMappings() {
        return this.mimeMappings;
    }

    public ResourceHandler setMimeMappings(MimeMappings mimeMappings) {
        this.mimeMappings = mimeMappings;
        return this;
    }

    public Predicate getCachable() {
        return this.cachable;
    }

    public ResourceHandler setCachable(Predicate cachable) {
        this.cachable = cachable;
        return this;
    }

    public Predicate getAllowed() {
        return this.allowed;
    }

    public ResourceHandler setAllowed(Predicate allowed) {
        this.allowed = allowed;
        return this;
    }

    public ResourceSupplier getResourceSupplier() {
        return this.resourceSupplier;
    }

    public ResourceHandler setResourceSupplier(ResourceSupplier resourceSupplier) {
        this.resourceSupplier = resourceSupplier;
        this.resourceManager = null;
        return this;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public ResourceHandler setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.resourceSupplier = new DefaultResourceSupplier(resourceManager);
        return this;
    }

    public Integer getCacheTime() {
        return this.cacheTime;
    }

    public ResourceHandler setCacheTime(Integer cacheTime) {
        this.cacheTime = cacheTime;
        return this;
    }

    public ContentEncodedResourceManager getContentEncodedResourceManager() {
        return this.contentEncodedResourceManager;
    }

    public ResourceHandler setContentEncodedResourceManager(ContentEncodedResourceManager contentEncodedResourceManager) {
        this.contentEncodedResourceManager = contentEncodedResourceManager;
        return this;
    }

    public boolean isCanonicalizePaths() {
        return this.canonicalizePaths;
    }

    public void setCanonicalizePaths(boolean canonicalizePaths) {
        this.canonicalizePaths = canonicalizePaths;
    }

    static {
        KNOWN_METHODS.add(Methods.OPTIONS);
        KNOWN_METHODS.add(Methods.GET);
        KNOWN_METHODS.add(Methods.HEAD);
        KNOWN_METHODS.add(Methods.POST);
        KNOWN_METHODS.add(Methods.PUT);
        KNOWN_METHODS.add(Methods.DELETE);
        KNOWN_METHODS.add(Methods.TRACE);
        KNOWN_METHODS.add(Methods.CONNECT);
    }

    private static class Wrapper
    implements HandlerWrapper {
        private final String location;
        private final boolean allowDirectoryListing;

        private Wrapper(String location, boolean allowDirectoryListing) {
            this.location = location;
            this.allowDirectoryListing = allowDirectoryListing;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            PathResourceManager rm = new PathResourceManager(Paths.get(this.location, new String[0]), 1024L);
            ResourceHandler resourceHandler = new ResourceHandler(rm);
            resourceHandler.setDirectoryListingEnabled(this.allowDirectoryListing);
            return resourceHandler;
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "resource";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("location", String.class);
            params.put("allow-listing", Boolean.TYPE);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("location");
        }

        @Override
        public String defaultParameter() {
            return "location";
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper((String)config.get("location"), (Boolean)config.get("allow-listing"));
        }
    }
}

