/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.ajp;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.conduits.ConduitListener;
import io.undertow.conduits.EmptyStreamSourceConduit;
import io.undertow.conduits.ReadDataStreamSourceConduit;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.AbstractServerConnection;
import io.undertow.server.ConnectorStatisticsImpl;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.ParseTimeoutUpdater;
import io.undertow.server.protocol.ajp.AjpRequestParseState;
import io.undertow.server.protocol.ajp.AjpRequestParser;
import io.undertow.server.protocol.ajp.AjpServerConnection;
import io.undertow.server.protocol.ajp.AjpServerRequestConduit;
import io.undertow.server.protocol.ajp.AjpServerResponseConduit;
import io.undertow.util.BadRequestException;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.StreamConnection;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.conduits.WriteReadyHandler;

final class AjpReadListener
implements ChannelListener<StreamSourceChannel> {
    private static final byte[] CPONG = new byte[]{65, 66, 0, 1, 9};
    private static final byte[] SEND_HEADERS_INTERNAL_SERVER_ERROR_MSG = new byte[]{65, 66, 0, 8, 4, 1, -12, 0, 0, 0, 0, 0};
    private static final byte[] SEND_HEADERS_BAD_REQUEST_MSG = new byte[]{65, 66, 0, 8, 4, 1, -112, 0, 0, 0, 0, 0};
    private static final byte[] END_RESPONSE = new byte[]{65, 66, 0, 2, 5, 0};
    private final AjpServerConnection connection;
    private final String scheme;
    private final boolean recordRequestStartTime;
    private AjpRequestParseState state = new AjpRequestParseState();
    private HttpServerExchange httpServerExchange;
    private volatile int read = 0;
    private final int maxRequestSize;
    private final long maxEntitySize;
    private final AjpRequestParser parser;
    private final ConnectorStatisticsImpl connectorStatistics;
    private WriteReadyHandler.ChannelListenerHandler<ConduitStreamSinkChannel> writeReadyHandler;
    private ParseTimeoutUpdater parseTimeoutUpdater;

    AjpReadListener(AjpServerConnection connection, String scheme, AjpRequestParser parser, ConnectorStatisticsImpl connectorStatistics) {
        this.connection = connection;
        this.scheme = scheme;
        this.parser = parser;
        this.connectorStatistics = connectorStatistics;
        this.maxRequestSize = connection.getUndertowOptions().get(UndertowOptions.MAX_HEADER_SIZE, 0x100000);
        this.maxEntitySize = connection.getUndertowOptions().get(UndertowOptions.MAX_ENTITY_SIZE, -1L);
        this.writeReadyHandler = new WriteReadyHandler.ChannelListenerHandler<ConduitStreamSinkChannel>(connection.getChannel().getSinkChannel());
        this.recordRequestStartTime = connection.getUndertowOptions().get(UndertowOptions.RECORD_REQUEST_START_TIME, false);
        int requestParseTimeout = connection.getUndertowOptions().get(UndertowOptions.REQUEST_PARSE_TIMEOUT, -1);
        int requestIdleTimeout = connection.getUndertowOptions().get(UndertowOptions.NO_REQUEST_TIMEOUT, -1);
        if (requestIdleTimeout < 0 && requestParseTimeout < 0) {
            this.parseTimeoutUpdater = null;
        } else {
            this.parseTimeoutUpdater = new ParseTimeoutUpdater(connection, requestParseTimeout, requestIdleTimeout);
            connection.addCloseListener(this.parseTimeoutUpdater);
        }
    }

    public void startRequest() {
        this.connection.resetChannel();
        this.state = new AjpRequestParseState();
        this.read = 0;
        if (this.parseTimeoutUpdater != null) {
            this.parseTimeoutUpdater.connectionIdle();
        }
        this.connection.setCurrentExchange(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(StreamSourceChannel channel) {
        if (this.connection.getOriginalSinkConduit().isWriteShutdown() || this.connection.getOriginalSourceConduit().isReadShutdown()) {
            IoUtils.safeClose((Closeable)this.connection);
            channel.suspendReads();
            return;
        }
        PooledByteBuffer existing = this.connection.getExtraBytes();
        PooledByteBuffer pooled = existing == null ? this.connection.getByteBufferPool().allocate() : existing;
        ByteBuffer buffer = pooled.getBuffer();
        boolean free = true;
        boolean bytesRead = false;
        try {
            do {
                int res;
                if (existing == null) {
                    buffer.clear();
                    res = channel.read(buffer);
                } else {
                    res = buffer.remaining();
                }
                if (res == 0) {
                    if (bytesRead && this.parseTimeoutUpdater != null) {
                        this.parseTimeoutUpdater.failedParse();
                    }
                    if (!channel.isReadResumed()) {
                        channel.getReadSetter().set(this);
                        channel.resumeReads();
                    }
                    return;
                }
                if (res == -1) {
                    channel.shutdownReads();
                    ConduitStreamSinkChannel responseChannel = this.connection.getChannel().getSinkChannel();
                    responseChannel.shutdownWrites();
                    IoUtils.safeClose((Closeable)this.connection);
                    return;
                }
                bytesRead = true;
                if (existing != null) {
                    existing = null;
                    this.connection.setExtraBytes(null);
                } else {
                    buffer.flip();
                }
                int begin = buffer.remaining();
                if (this.httpServerExchange == null) {
                    this.httpServerExchange = new HttpServerExchange(this.connection, this.maxEntitySize);
                }
                this.parser.parse(buffer, this.state, this.httpServerExchange);
                this.read += begin - buffer.remaining();
                if (buffer.hasRemaining()) {
                    free = false;
                    this.connection.setExtraBytes(pooled);
                }
                if (this.read <= this.maxRequestSize) continue;
                UndertowLogger.REQUEST_LOGGER.requestHeaderWasTooLarge(this.connection.getPeerAddress(), this.maxRequestSize);
                throw UndertowMessages.MESSAGES.badRequest();
            } while (!this.state.isComplete());
            if (this.parseTimeoutUpdater != null) {
                this.parseTimeoutUpdater.requestStarted();
            }
            if (this.state.prefix != 2) {
                if (this.state.prefix == 10) {
                    UndertowLogger.REQUEST_LOGGER.debug("Received CPING, sending CPONG");
                    this.handleCPing();
                } else if (this.state.prefix == 9) {
                    UndertowLogger.REQUEST_LOGGER.debug("Received CPONG, starting next request");
                    this.state = new AjpRequestParseState();
                    channel.getReadSetter().set(this);
                    channel.resumeReads();
                } else {
                    UndertowLogger.REQUEST_LOGGER.ignoringAjpRequestWithPrefixCode(this.state.prefix);
                    IoUtils.safeClose((Closeable)this.connection);
                }
                return;
            }
            channel.getReadSetter().set(null);
            channel.suspendReads();
            final HttpServerExchange httpServerExchange = this.httpServerExchange;
            AjpServerResponseConduit responseConduit = new AjpServerResponseConduit(this.connection.getChannel().getSinkChannel().getConduit(), this.connection.getByteBufferPool(), httpServerExchange, (ConduitListener<? super AjpServerResponseConduit>)new ConduitListener<AjpServerResponseConduit>(){

                @Override
                public void handleEvent(AjpServerResponseConduit channel) {
                    Connectors.terminateResponse(httpServerExchange);
                }
            }, httpServerExchange.getRequestMethod().equals(Methods.HEAD));
            this.connection.getChannel().getSinkChannel().setConduit(responseConduit);
            this.connection.getChannel().getSourceChannel().setConduit(this.createSourceConduit(this.connection.getChannel().getSourceChannel().getConduit(), responseConduit, httpServerExchange));
            responseConduit.setWriteReadyHandler(this.writeReadyHandler);
            this.connection.setSSLSessionInfo(this.state.createSslSessionInfo());
            httpServerExchange.setSourceAddress(this.state.createPeerAddress());
            httpServerExchange.setDestinationAddress(this.state.createDestinationAddress());
            if (this.scheme != null) {
                httpServerExchange.setRequestScheme(this.scheme);
            }
            if (this.state.attributes != null) {
                httpServerExchange.putAttachment(HttpServerExchange.REQUEST_ATTRIBUTES, this.state.attributes);
            }
            AjpRequestParseState oldState = this.state;
            this.state = null;
            this.httpServerExchange = null;
            httpServerExchange.setPersistent(true);
            if (this.recordRequestStartTime) {
                Connectors.setRequestStartTime(httpServerExchange);
            }
            this.connection.setCurrentExchange(httpServerExchange);
            if (this.connectorStatistics != null) {
                this.connectorStatistics.setup(httpServerExchange);
            }
            if (!Connectors.areRequestHeadersValid(httpServerExchange.getRequestHeaders())) {
                oldState.badRequest = true;
                UndertowLogger.REQUEST_IO_LOGGER.debugf("Invalid AJP request from %s, request contained invalid headers", (Object)this.connection.getPeerAddress());
            }
            if (oldState.badRequest) {
                httpServerExchange.setStatusCode(400);
                httpServerExchange.endExchange();
                IoUtils.safeClose((Closeable)this.connection);
            } else {
                Connectors.executeRootHandler(this.connection.getRootHandler(), httpServerExchange);
            }
        }
        catch (BadRequestException e) {
            UndertowLogger.REQUEST_IO_LOGGER.failedToParseRequest(e);
            this.handleBadRequest();
            IoUtils.safeClose((Closeable)this.connection);
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            this.handleInternalServerError();
            IoUtils.safeClose((Closeable)this.connection);
        }
        catch (Throwable t) {
            UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest(t);
            this.handleInternalServerError();
            IoUtils.safeClose((Closeable)this.connection);
        }
        finally {
            if (free) {
                pooled.close();
            }
        }
    }

    private void handleInternalServerError() {
        this.sendMessages(SEND_HEADERS_INTERNAL_SERVER_ERROR_MSG, END_RESPONSE);
    }

    private void handleBadRequest() {
        this.sendMessages(SEND_HEADERS_BAD_REQUEST_MSG, END_RESPONSE);
    }

    private void handleCPing() {
        if (this.sendMessages(new byte[][]{CPONG})) {
            this.handleEvent(this.connection.getChannel().getSourceChannel());
        }
    }

    private boolean sendMessages(byte[] ... rawMessages) {
        this.state = new AjpRequestParseState();
        final StreamConnection underlyingChannel = this.connection.getChannel();
        underlyingChannel.getSourceChannel().suspendReads();
        int bufferSize = 0;
        for (int i2 = 0; i2 < rawMessages.length; ++i2) {
            bufferSize += rawMessages[i2].length;
        }
        final ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        for (int i3 = 0; i3 < rawMessages.length; ++i3) {
            buffer.put(rawMessages[i3]);
        }
        buffer.flip();
        try {
            do {
                int res;
                if ((res = underlyingChannel.getSinkChannel().write(buffer)) != 0) continue;
                underlyingChannel.getSinkChannel().setWriteListener((ChannelListener<? super ConduitStreamSinkChannel>)new ChannelListener<ConduitStreamSinkChannel>(){

                    @Override
                    public void handleEvent(ConduitStreamSinkChannel channel) {
                        do {
                            try {
                                int res = channel.write(buffer);
                                if (res == 0) {
                                    return;
                                }
                            }
                            catch (IOException e) {
                                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                                IoUtils.safeClose((Closeable)AjpReadListener.this.connection);
                            }
                        } while (buffer.hasRemaining());
                        channel.suspendWrites();
                        AjpReadListener.this.handleEvent(underlyingChannel.getSourceChannel());
                    }
                });
                underlyingChannel.getSinkChannel().resumeWrites();
                return false;
            } while (buffer.hasRemaining());
            return true;
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            IoUtils.safeClose((Closeable)this.connection);
            return false;
        }
    }

    public void exchangeComplete(HttpServerExchange exchange2) {
        if (!exchange2.isUpgrade() && exchange2.isPersistent()) {
            this.startRequest();
            ConduitStreamSourceChannel channel = ((AjpServerConnection)exchange2.getConnection()).getChannel().getSourceChannel();
            channel.getReadSetter().set(this);
            channel.wakeupReads();
        } else if (!exchange2.isPersistent()) {
            IoUtils.safeClose((Closeable)exchange2.getConnection());
        }
    }

    private StreamSourceConduit createSourceConduit(StreamSourceConduit underlyingConduit, AjpServerResponseConduit responseConduit, final HttpServerExchange exchange2) throws BadRequestException {
        Long length;
        boolean hasTransferEncoding;
        ReadDataStreamSourceConduit conduit = new ReadDataStreamSourceConduit(underlyingConduit, (AbstractServerConnection)exchange2.getConnection());
        HeaderMap requestHeaders = exchange2.getRequestHeaders();
        HttpString transferEncoding = Headers.IDENTITY;
        String teHeader = requestHeaders.getLast(Headers.TRANSFER_ENCODING);
        boolean bl = hasTransferEncoding = teHeader != null;
        if (hasTransferEncoding) {
            transferEncoding = new HttpString(teHeader);
        }
        String requestContentLength = requestHeaders.getFirst(Headers.CONTENT_LENGTH);
        if (hasTransferEncoding && !transferEncoding.equals(Headers.IDENTITY)) {
            length = null;
        } else if (requestContentLength != null) {
            try {
                long contentLength = Long.parseLong(requestContentLength);
                if (contentLength == 0L) {
                    UndertowLogger.REQUEST_LOGGER.trace("No content, starting next request");
                    Connectors.terminateRequest(this.httpServerExchange);
                    return new EmptyStreamSourceConduit(conduit.getReadThread());
                }
                length = contentLength;
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("Invalid Content-Length header", e);
            }
        } else {
            UndertowLogger.REQUEST_LOGGER.trace("No content length or transfer coding, starting next request");
            Connectors.terminateRequest(exchange2);
            return new EmptyStreamSourceConduit(conduit.getReadThread());
        }
        return new AjpServerRequestConduit(conduit, exchange2, responseConduit, length, (ConduitListener<? super AjpServerRequestConduit>)new ConduitListener<AjpServerRequestConduit>(){

            @Override
            public void handleEvent(AjpServerRequestConduit channel) {
                Connectors.terminateRequest(exchange2);
            }
        });
    }
}

