/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http2;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.io.IoCallback;
import io.undertow.io.Receiver;
import io.undertow.io.Sender;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.server.Connectors;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.server.protocol.http.HttpContinue;
import io.undertow.server.protocol.http2.Http2ReceiveListener;
import io.undertow.util.FlexBase64;
import io.undertow.util.Headers;
import io.undertow.util.ImmediatePooledByteBuffer;
import io.undertow.util.Protocols;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;

public class Http2UpgradeHandler
implements HttpHandler {
    private final HttpHandler next;
    private final Set<String> upgradeStrings;

    public Http2UpgradeHandler(HttpHandler next) {
        this.next = next;
        this.upgradeStrings = Collections.singleton("h2c");
    }

    public Http2UpgradeHandler(HttpHandler next, String ... upgradeStrings) {
        this.next = next;
        this.upgradeStrings = new HashSet<String>(Arrays.asList(upgradeStrings));
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        final String upgrade = exchange2.getRequestHeaders().getFirst(Headers.UPGRADE);
        final String settings = exchange2.getRequestHeaders().getFirst("HTTP2-Settings");
        if (settings != null && upgrade != null && this.upgradeStrings.contains(upgrade)) {
            if (HttpContinue.requiresContinueResponse(exchange2)) {
                HttpContinue.sendContinueResponse(exchange2, new IoCallback(){

                    @Override
                    public void onComplete(HttpServerExchange exchange2, Sender sender) {
                        try {
                            Http2UpgradeHandler.this.handleUpgradeBody(exchange2, upgrade, settings);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public void onException(HttpServerExchange exchange2, Sender sender, IOException exception) {
                        exchange2.setStatusCode(500);
                        exchange2.endExchange();
                    }
                });
            } else {
                this.handleUpgradeBody(exchange2, upgrade, settings);
            }
            return;
        }
        this.next.handleRequest(exchange2);
    }

    private void handleUpgradeBody(HttpServerExchange exchange2, final String upgrade, final String settings) throws Exception {
        if (exchange2.isRequestComplete()) {
            this.handleHttp2Upgrade(exchange2, upgrade, settings, null);
        } else {
            final int maxBufferedSize = exchange2.getConnection().getUndertowOptions().get(UndertowOptions.MAX_BUFFERED_REQUEST_SIZE, 16384);
            if (exchange2.getRequestContentLength() > (long)maxBufferedSize) {
                this.next.handleRequest(exchange2);
            } else if (exchange2.getRequestContentLength() > 0L && exchange2.getRequestContentLength() < (long)maxBufferedSize) {
                exchange2.getRequestReceiver().receiveFullBytes(new Receiver.FullBytesCallback(){

                    @Override
                    public void handle(HttpServerExchange exchange2, byte[] message) {
                        try {
                            Http2UpgradeHandler.this.handleHttp2Upgrade(exchange2, upgrade, settings, message);
                        }
                        catch (IOException e) {
                            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                            exchange2.endExchange();
                        }
                    }
                });
            } else {
                final ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
                exchange2.getRequestReceiver().receivePartialBytes(new Receiver.PartialBytesCallback(){

                    @Override
                    public void handle(HttpServerExchange exchange2, byte[] message, boolean last) {
                        try {
                            outputStream2.write(message);
                            if (last) {
                                Http2UpgradeHandler.this.handleHttp2Upgrade(exchange2, upgrade, settings, outputStream2.toByteArray());
                            } else if (outputStream2.size() >= maxBufferedSize) {
                                exchange2.getRequestReceiver().pause();
                                Connectors.ungetRequestBytes(exchange2, new ImmediatePooledByteBuffer(ByteBuffer.wrap(outputStream2.toByteArray())));
                                Connectors.resetRequestChannel(exchange2);
                                Http2UpgradeHandler.this.next.handleRequest(exchange2);
                            }
                        }
                        catch (IOException e) {
                            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                            exchange2.endExchange();
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        }
    }

    private void handleHttp2Upgrade(HttpServerExchange exchange2, final String upgrade, String settings, final byte[] data) throws IOException {
        final ByteBuffer settingsFrame = FlexBase64.decodeURL(settings);
        exchange2.getResponseHeaders().put(Headers.UPGRADE, upgrade);
        exchange2.upgradeChannel(new HttpUpgradeListener(){

            @Override
            public void handleUpgrade(StreamConnection streamConnection, HttpServerExchange exchange2) {
                OptionMap undertowOptions = exchange2.getConnection().getUndertowOptions();
                Http2Channel channel = new Http2Channel(streamConnection, upgrade, exchange2.getConnection().getByteBufferPool(), null, false, true, true, settingsFrame, undertowOptions);
                Http2ReceiveListener receiveListener = new Http2ReceiveListener(new HttpHandler(){

                    @Override
                    public void handleRequest(HttpServerExchange exchange2) throws Exception {
                        if (exchange2.getRequestHeaders().contains("X-HTTP2-connect-only")) {
                            exchange2.endExchange();
                            return;
                        }
                        exchange2.setProtocol(Protocols.HTTP_2_0);
                        Http2UpgradeHandler.this.next.handleRequest(exchange2);
                    }
                }, undertowOptions, exchange2.getConnection().getBufferSize(), null);
                channel.getReceiveSetter().set(receiveListener);
                boolean decodeURL = undertowOptions.get(UndertowOptions.DECODE_URL, true);
                boolean allowUnescapedCharactersInURL = undertowOptions.get(UndertowOptions.ALLOW_UNESCAPED_CHARACTERS_IN_URL, false);
                receiveListener.handleInitialRequest(exchange2, channel, data, decodeURL && !allowUnescapedCharactersInURL, decodeURL);
                channel.resumeReceives();
            }
        });
    }
}

