/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import org.wildfly.common.Assert;

public class HexConverter {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final byte[] HEX_BYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public static String convertToHexString(byte[] toBeConverted) {
        Assert.checkNotNullParamWithNullPointerException("toBeConverted", toBeConverted);
        char[] converted = new char[toBeConverted.length * 2];
        for (int i2 = 0; i2 < toBeConverted.length; ++i2) {
            byte b = toBeConverted[i2];
            converted[i2 * 2] = HEX_CHARS[b >> 4 & 0xF];
            converted[i2 * 2 + 1] = HEX_CHARS[b & 0xF];
        }
        return String.valueOf(converted);
    }

    public static byte[] convertToHexBytes(byte[] toBeConverted) {
        Assert.checkNotNullParamWithNullPointerException("toBeConverted", toBeConverted);
        byte[] converted = new byte[toBeConverted.length * 2];
        for (int i2 = 0; i2 < toBeConverted.length; ++i2) {
            byte b = toBeConverted[i2];
            converted[i2 * 2] = HEX_BYTES[b >> 4 & 0xF];
            converted[i2 * 2 + 1] = HEX_BYTES[b & 0xF];
        }
        return converted;
    }

    public static byte[] convertFromHex(char[] toConvert) {
        if (toConvert.length % 2 != 0) {
            throw new IllegalArgumentException("The supplied character array must contain an even number of hex chars.");
        }
        byte[] response = new byte[toConvert.length / 2];
        for (int i2 = 0; i2 < response.length; ++i2) {
            int posOne = i2 * 2;
            response[i2] = (byte)(HexConverter.toByte(toConvert, posOne) << 4 | HexConverter.toByte(toConvert, posOne + 1));
        }
        return response;
    }

    private static byte toByte(char[] toConvert, int pos) {
        int response = Character.digit(toConvert[pos], 16);
        if (response < 0 || response > 15) {
            throw new IllegalArgumentException("Non-hex character '" + toConvert[pos] + "' at index=" + pos);
        }
        return (byte)response;
    }

    public static byte[] convertFromHex(String toConvert) {
        return HexConverter.convertFromHex(toConvert.toCharArray());
    }

    public static void main(String[] args2) {
        byte[] toConvert = new byte[256];
        for (int i2 = 0; i2 < toConvert.length; ++i2) {
            toConvert[i2] = (byte)i2;
        }
        String hexValue = HexConverter.convertToHexString(toConvert);
        System.out.println("Converted - " + hexValue);
        byte[] convertedBack = HexConverter.convertFromHex(hexValue);
        StringBuilder sb = new StringBuilder();
        for (byte current : convertedBack) {
            sb.append(current).append(" ");
        }
        System.out.println("Converted Back " + sb.toString());
    }
}

