/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol;

import io.undertow.connector.ByteBufferPool;
import io.undertow.websockets.WebSocketExtension;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.extensions.ExtensionFunction;
import io.undertow.websockets.extensions.ExtensionHandshake;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.xnio.IoFuture;
import org.xnio.StreamConnection;

public abstract class Handshake {
    private final WebSocketVersion version;
    private final String hashAlgorithm;
    private final String magicNumber;
    protected final Set<String> subprotocols;
    private static final byte[] EMPTY = new byte[0];
    private static final Pattern PATTERN = Pattern.compile("\\s*,\\s*");
    protected Set<ExtensionHandshake> availableExtensions = new HashSet<ExtensionHandshake>();
    protected boolean allowExtensions;

    protected Handshake(WebSocketVersion version, String hashAlgorithm, String magicNumber, Set<String> subprotocols) {
        this.version = version;
        this.hashAlgorithm = hashAlgorithm;
        this.magicNumber = magicNumber;
        this.subprotocols = subprotocols;
    }

    public WebSocketVersion getVersion() {
        return this.version;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String getMagicNumber() {
        return this.magicNumber;
    }

    protected static String getWebSocketLocation(WebSocketHttpExchange exchange2) {
        String scheme = "https".equals(exchange2.getRequestScheme()) ? "wss" : "ws";
        return scheme + "://" + exchange2.getRequestHeader("Host") + exchange2.getRequestURI();
    }

    public final void handshake(WebSocketHttpExchange exchange2) {
        exchange2.putAttachment(WebSocketVersion.ATTACHMENT_KEY, this.version);
        this.handshakeInternal(exchange2);
    }

    protected abstract void handshakeInternal(WebSocketHttpExchange var1);

    public abstract boolean matches(WebSocketHttpExchange var1);

    public abstract WebSocketChannel createChannel(WebSocketHttpExchange var1, StreamConnection var2, ByteBufferPool var3);

    protected final void performUpgrade(WebSocketHttpExchange exchange2, byte[] data) {
        exchange2.setResponseHeader("Content-Length", String.valueOf(data.length));
        exchange2.setResponseHeader("Upgrade", "WebSocket");
        exchange2.setResponseHeader("Connection", "Upgrade");
        this.upgradeChannel(exchange2, data);
    }

    protected void upgradeChannel(WebSocketHttpExchange exchange2, byte[] data) {
        if (data.length > 0) {
            Handshake.writePayload(exchange2, ByteBuffer.wrap(data));
        } else {
            exchange2.endExchange();
        }
    }

    private static void writePayload(final WebSocketHttpExchange exchange2, ByteBuffer payload) {
        exchange2.sendData(payload).addNotifier(new IoFuture.Notifier<Void, Object>(){

            @Override
            public void notify(IoFuture<? extends Void> ioFuture, Object attachment) {
                if (ioFuture.getStatus() == IoFuture.Status.DONE) {
                    exchange2.endExchange();
                } else {
                    exchange2.close();
                }
            }
        }, null);
    }

    protected final void performUpgrade(WebSocketHttpExchange exchange2) {
        this.performUpgrade(exchange2, EMPTY);
    }

    protected final void selectSubprotocol(WebSocketHttpExchange exchange2) {
        String requestedSubprotocols = exchange2.getRequestHeader("Sec-WebSocket-Protocol");
        if (requestedSubprotocols == null) {
            return;
        }
        String[] requestedSubprotocolArray = PATTERN.split(requestedSubprotocols);
        String subProtocol = this.supportedSubprotols(requestedSubprotocolArray);
        if (subProtocol != null && !subProtocol.isEmpty()) {
            exchange2.setResponseHeader("Sec-WebSocket-Protocol", subProtocol);
        }
    }

    protected final void selectExtensions(WebSocketHttpExchange exchange2) {
        List<WebSocketExtension> requestedExtensions = WebSocketExtension.parse(exchange2.getRequestHeader("Sec-WebSocket-Extensions"));
        List<WebSocketExtension> extensions = this.selectedExtension(requestedExtensions);
        if (extensions != null && !extensions.isEmpty()) {
            exchange2.setResponseHeader("Sec-WebSocket-Extensions", WebSocketExtension.toExtensionHeader(extensions));
        }
    }

    protected String supportedSubprotols(String[] requestedSubprotocolArray) {
        for (String p : requestedSubprotocolArray) {
            String requestedSubprotocol = p.trim();
            for (String supportedSubprotocol : this.subprotocols) {
                if (!requestedSubprotocol.equals(supportedSubprotocol)) continue;
                return supportedSubprotocol;
            }
        }
        return null;
    }

    protected List<WebSocketExtension> selectedExtension(List<WebSocketExtension> extensionList) {
        ArrayList<WebSocketExtension> selected = new ArrayList<WebSocketExtension>();
        ArrayList<ExtensionHandshake> configured = new ArrayList<ExtensionHandshake>();
        for (WebSocketExtension ext : extensionList) {
            for (ExtensionHandshake extHandshake : this.availableExtensions) {
                WebSocketExtension negotiated = extHandshake.accept(ext);
                if (negotiated == null || extHandshake.isIncompatible(configured)) continue;
                selected.add(negotiated);
                configured.add(extHandshake);
            }
        }
        return selected;
    }

    public final void addExtension(ExtensionHandshake extension) {
        this.availableExtensions.add(extension);
        this.allowExtensions = true;
    }

    protected final List<ExtensionFunction> initExtensions(WebSocketHttpExchange exchange2) {
        List<WebSocketExtension> extensions;
        String extHeader = exchange2.getResponseHeaders().get("Sec-WebSocket-Extensions") != null ? exchange2.getResponseHeaders().get("Sec-WebSocket-Extensions").get(0) : null;
        ArrayList<ExtensionFunction> negotiated = new ArrayList<ExtensionFunction>();
        if (extHeader != null && (extensions = WebSocketExtension.parse(extHeader)) != null && !extensions.isEmpty()) {
            for (WebSocketExtension ext : extensions) {
                for (ExtensionHandshake extHandshake : this.availableExtensions) {
                    if (!extHandshake.getName().equals(ext.getName())) continue;
                    negotiated.add(extHandshake.create());
                }
            }
        }
        return negotiated;
    }
}

