/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ExpressionFactory;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;

class ExpressionFactoryCache {
    private final AtomicReference<WeakHashMap<ClassLoader, WeakReference<ExpressionFactory>>> factoryCache = new AtomicReference(new WeakHashMap());

    ExpressionFactoryCache() {
    }

    ExpressionFactory getOrCreateExpressionFactory(ClassLoader cl) {
        WeakHashMap<ClassLoader, WeakReference<ExpressionFactory>> newCache;
        WeakHashMap<ClassLoader, WeakReference<ExpressionFactory>> cache;
        ExpressionFactory factory2 = null;
        do {
            WeakReference<ExpressionFactory> factoryRef;
            if ((factoryRef = (cache = this.factoryCache.get()).get(cl)) != null && (factory2 = (ExpressionFactory)factoryRef.get()) != null) {
                return factory2;
            }
            if (factory2 == null) {
                factory2 = ExpressionFactory.newInstance();
            }
            factoryRef = new WeakReference<ExpressionFactory>(factory2);
            newCache = new WeakHashMap<ClassLoader, WeakReference<ExpressionFactory>>(cache);
            newCache.put(cl, factoryRef);
        } while (!this.factoryCache.compareAndSet(cache, newCache));
        return factory2;
    }
}

