/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.appender;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import net.logstash.logback.appender.AsyncDisruptorAppender;
import net.logstash.logback.appender.listener.AppenderListener;
import net.logstash.logback.encoder.com.lmax.disruptor.EventHandler;

public abstract class DelegatingAsyncDisruptorAppender<Event extends DeferredProcessingAware, Listener extends AppenderListener<Event>>
extends AsyncDisruptorAppender<Event, Listener>
implements AppenderAttachable<Event> {
    private final AppenderAttachableImpl<Event> appenders = new AppenderAttachableImpl();

    @Override
    protected EventHandler<AsyncDisruptorAppender.LogEvent<Event>> createEventHandler() {
        return new DelegatingEventHandler();
    }

    @Override
    public void start() {
        this.startDelegateAppenders();
        super.start();
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        this.stopDelegateAppenders();
    }

    private void startDelegateAppenders() {
        Iterator<Appender<Event>> appenderIter = this.appenders.iteratorForAppenders();
        while (appenderIter.hasNext()) {
            Appender<Event> appender = appenderIter.next();
            if (appender.getContext() == null) {
                appender.setContext(this.getContext());
            }
            if (appender.isStarted()) continue;
            appender.start();
        }
    }

    private void stopDelegateAppenders() {
        Iterator<Appender<Event>> appenderIter = this.appenders.iteratorForAppenders();
        while (appenderIter.hasNext()) {
            Appender<Event> appender = appenderIter.next();
            if (!appender.isStarted()) continue;
            appender.stop();
        }
    }

    @Override
    public void addAppender(Appender<Event> newAppender) {
        this.appenders.addAppender(newAppender);
    }

    @Override
    public Iterator<Appender<Event>> iteratorForAppenders() {
        return this.appenders.iteratorForAppenders();
    }

    @Override
    public Appender<Event> getAppender(String name) {
        return this.appenders.getAppender(name);
    }

    @Override
    public boolean isAttached(Appender<Event> appender) {
        return this.appenders.isAttached(appender);
    }

    @Override
    public void detachAndStopAllAppenders() {
        this.appenders.detachAndStopAllAppenders();
    }

    @Override
    public boolean detachAppender(Appender<Event> appender) {
        return this.appenders.detachAppender(appender);
    }

    @Override
    public boolean detachAppender(String name) {
        return this.appenders.detachAppender(name);
    }

    private class DelegatingEventHandler
    implements EventHandler<AsyncDisruptorAppender.LogEvent<Event>> {
        private boolean silentError;

        private DelegatingEventHandler() {
        }

        @Override
        public void onEvent(AsyncDisruptorAppender.LogEvent<Event> logEvent, long sequence2, boolean endOfBatch) throws Exception {
            boolean exceptionThrown = false;
            Iterator it = DelegatingAsyncDisruptorAppender.this.appenders.iteratorForAppenders();
            while (it.hasNext()) {
                Appender appender = it.next();
                try {
                    appender.doAppend((DeferredProcessingAware)logEvent.event);
                    if (!endOfBatch) continue;
                    this.flushAppender(appender);
                }
                catch (Exception e) {
                    exceptionThrown = true;
                    if (this.silentError) continue;
                    DelegatingAsyncDisruptorAppender.this.addError(String.format("Unable to forward event to appender [%s]: %s", appender.getName(), e.getMessage()), e);
                }
            }
            this.silentError = exceptionThrown;
        }

        private void flushAppender(Appender<Event> appender) throws IOException {
            if (!appender.isStarted()) {
                return;
            }
            if (appender instanceof Flushable) {
                this.flushAppender((Flushable)((Object)appender));
            } else if (appender instanceof OutputStreamAppender) {
                this.flushAppender((OutputStreamAppender)appender);
            }
        }

        private void flushAppender(OutputStreamAppender<Event> appender) throws IOException {
            OutputStream os;
            if (!appender.isImmediateFlush() && (os = appender.getOutputStream()) != null) {
                os.flush();
            }
        }

        private void flushAppender(Flushable appender) throws IOException {
            appender.flush();
        }
    }
}

