/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.CloseUtil;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import net.logstash.logback.composite.JsonProviders;
import net.logstash.logback.decorate.JsonFactoryDecorator;
import net.logstash.logback.decorate.JsonGeneratorDecorator;
import net.logstash.logback.decorate.NullJsonFactoryDecorator;
import net.logstash.logback.decorate.NullJsonGeneratorDecorator;
import net.logstash.logback.util.ProxyOutputStream;
import net.logstash.logback.util.SimpleObjectJsonGeneratorDelegate;
import net.logstash.logback.util.ThreadLocalHolder;

public abstract class AbstractCompositeJsonFormatter<Event extends DeferredProcessingAware>
extends ContextAwareBase
implements LifeCycle {
    private JsonFactory jsonFactory;
    private JsonFactoryDecorator jsonFactoryDecorator;
    private JsonGeneratorDecorator jsonGeneratorDecorator;
    private JsonProviders<Event> jsonProviders = new JsonProviders();
    private JsonEncoding encoding = JsonEncoding.UTF8;
    private boolean findAndRegisterJacksonModules = true;
    private volatile boolean started;
    private ThreadLocalHolder<JsonFormatter> threadLocalJsonFormatter;

    public AbstractCompositeJsonFormatter(ContextAware declaredOrigin) {
        super(declaredOrigin);
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        if (this.jsonFactoryDecorator == null) {
            this.jsonFactoryDecorator = new NullJsonFactoryDecorator();
        }
        if (this.jsonGeneratorDecorator == null) {
            this.jsonGeneratorDecorator = new NullJsonGeneratorDecorator();
        }
        if (this.jsonProviders.getProviders().isEmpty()) {
            this.addError("No providers configured");
        }
        this.jsonFactory = this.createJsonFactory();
        this.jsonProviders.setContext(this.context);
        this.jsonProviders.setJsonFactory(this.jsonFactory);
        this.jsonProviders.start();
        this.threadLocalJsonFormatter = new ThreadLocalHolder<JsonFormatter>(this::createJsonFormatter);
        this.started = true;
    }

    @Override
    public void stop() {
        if (this.isStarted()) {
            this.threadLocalJsonFormatter.close();
            this.jsonProviders.stop();
            this.jsonFactory = null;
            this.started = false;
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public void writeEvent(Event event, OutputStream outputStream2) throws IOException {
        Objects.requireNonNull(outputStream2);
        if (!this.isStarted()) {
            throw new IllegalStateException("Formatter is not started");
        }
        try (JsonFormatter formatter = this.threadLocalJsonFormatter.acquire();){
            formatter.writeEvent(outputStream2, event);
        }
    }

    private JsonFormatter createJsonFormatter() {
        try {
            DisconnectedOutputStream outputStream2 = new DisconnectedOutputStream();
            JsonGenerator generator = this.createGenerator(outputStream2);
            return new JsonFormatter(outputStream2, generator);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to initialize Jackson JSON layer", e);
        }
    }

    private JsonFactory createJsonFactory() {
        ObjectMapper objectMapper = new ObjectMapper().disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        if (this.findAndRegisterJacksonModules) {
            try {
                objectMapper.findAndRegisterModules();
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                this.addError("Error occurred while dynamically loading jackson modules", serviceConfigurationError);
            }
        }
        return this.decorateFactory(objectMapper.getFactory());
    }

    private JsonFactory decorateFactory(JsonFactory factory2) {
        JsonFactory factoryToDecorate = factory2.disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
        return this.jsonFactoryDecorator.decorate(factoryToDecorate).disable(JsonFactory.Feature.USE_THREAD_LOCAL_FOR_BUFFER_RECYCLING);
    }

    protected void writeEventToGenerator(JsonGenerator generator, Event event) throws IOException {
        generator.writeStartObject();
        this.jsonProviders.writeTo(generator, event);
        generator.writeEndObject();
        generator.flush();
    }

    protected void prepareForDeferredProcessing(Event event) {
        event.prepareForDeferredProcessing();
        this.jsonProviders.prepareForDeferredProcessing(event);
    }

    private JsonGenerator createGenerator(OutputStream outputStream2) throws IOException {
        return this.decorateGenerator(this.jsonFactory.createGenerator(outputStream2, this.encoding));
    }

    private JsonGenerator decorateGenerator(JsonGenerator generator) {
        JsonGenerator decorated = this.jsonGeneratorDecorator.decorate(new SimpleObjectJsonGeneratorDelegate(generator)).disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        try {
            decorated = decorated.setRootValueSeparator(new SerializedString(""));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return decorated;
    }

    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public JsonFactoryDecorator getJsonFactoryDecorator() {
        return this.jsonFactoryDecorator;
    }

    public void setJsonFactoryDecorator(JsonFactoryDecorator jsonFactoryDecorator) {
        this.jsonFactoryDecorator = jsonFactoryDecorator;
    }

    public JsonGeneratorDecorator getJsonGeneratorDecorator() {
        return this.jsonGeneratorDecorator;
    }

    public void setJsonGeneratorDecorator(JsonGeneratorDecorator jsonGeneratorDecorator) {
        this.jsonGeneratorDecorator = jsonGeneratorDecorator;
    }

    public JsonProviders<Event> getProviders() {
        return this.jsonProviders;
    }

    public String getEncoding() {
        return this.encoding.getJavaName();
    }

    public void setEncoding(String encodingName) {
        for (JsonEncoding encoding : JsonEncoding.values()) {
            if (!encoding.getJavaName().equalsIgnoreCase(encodingName) && !encoding.name().equalsIgnoreCase(encodingName)) continue;
            this.encoding = encoding;
            return;
        }
        throw new IllegalArgumentException("Unknown encoding " + encodingName);
    }

    public void setProviders(JsonProviders<Event> jsonProviders) {
        this.jsonProviders = Objects.requireNonNull(jsonProviders);
    }

    public boolean isFindAndRegisterJacksonModules() {
        return this.findAndRegisterJacksonModules;
    }

    public void setFindAndRegisterJacksonModules(boolean findAndRegisterJacksonModules) {
        this.findAndRegisterJacksonModules = findAndRegisterJacksonModules;
    }

    private class JsonFormatter
    implements ThreadLocalHolder.Lifecycle,
    Closeable {
        private final JsonGenerator generator;
        private final DisconnectedOutputStream stream;
        private boolean recyclable = true;

        JsonFormatter(DisconnectedOutputStream outputStream2, JsonGenerator generator) {
            this.stream = Objects.requireNonNull(outputStream2);
            this.generator = Objects.requireNonNull(generator);
        }

        public void writeEvent(OutputStream outputStream2, Event event) throws IOException {
            try {
                this.stream.connect(outputStream2);
                AbstractCompositeJsonFormatter.this.writeEventToGenerator(this.generator, event);
            }
            catch (IOException | RuntimeException e) {
                this.recyclable = false;
                throw e;
            }
            finally {
                this.stream.disconnect();
            }
        }

        @Override
        public boolean recycle() {
            return this.recyclable;
        }

        @Override
        public void dispose() {
            CloseUtil.closeQuietly(this.generator);
        }

        @Override
        public void close() throws IOException {
            AbstractCompositeJsonFormatter.this.threadLocalJsonFormatter.release();
        }
    }

    private static class DisconnectedOutputStream
    extends ProxyOutputStream {
        DisconnectedOutputStream() {
            super(null);
        }

        public void connect(OutputStream out) {
            this.delegate = out;
        }

        public void disconnect() {
            this.delegate = null;
        }
    }
}

