/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite.loggingevent;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import net.logstash.logback.composite.AbstractJsonProvider;
import net.logstash.logback.marker.LogstashMarker;
import org.slf4j.Marker;

public class LogstashMarkersJsonProvider
extends AbstractJsonProvider<ILoggingEvent> {
    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) throws IOException {
        this.writeLogstashMarkerIfNecessary(generator, event.getMarkerList());
    }

    private void writeLogstashMarkerIfNecessary(JsonGenerator generator, List<Marker> markers) throws IOException {
        if (markers != null) {
            for (Marker marker : markers) {
                this.writeLogstashMarkerIfNecessary(generator, marker);
            }
        }
    }

    private void writeLogstashMarkerIfNecessary(JsonGenerator generator, Marker marker) throws IOException {
        if (marker != null) {
            if (LogstashMarkersJsonProvider.isLogstashMarker(marker)) {
                ((LogstashMarker)marker).writeTo(generator);
            }
            if (marker.hasReferences()) {
                Iterator<Marker> i2 = marker.iterator();
                while (i2.hasNext()) {
                    Marker next = i2.next();
                    this.writeLogstashMarkerIfNecessary(generator, next);
                }
            }
        }
    }

    public static boolean isLogstashMarker(Marker marker) {
        return marker instanceof LogstashMarker;
    }
}

