/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder.com.lmax.disruptor;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.logstash.logback.encoder.com.lmax.disruptor.AlertException;
import net.logstash.logback.encoder.com.lmax.disruptor.Sequence;
import net.logstash.logback.encoder.com.lmax.disruptor.SequenceBarrier;
import net.logstash.logback.encoder.com.lmax.disruptor.WaitStrategy;
import net.logstash.logback.encoder.com.lmax.disruptor.util.ThreadHints;

public final class BlockingWaitStrategy
implements WaitStrategy {
    private final Lock lock = new ReentrantLock();
    private final Condition processorNotifyCondition = this.lock.newCondition();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitFor(long sequence2, Sequence cursorSequence, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException {
        long availableSequence;
        if (cursorSequence.get() < sequence2) {
            this.lock.lock();
            try {
                while (cursorSequence.get() < sequence2) {
                    barrier.checkAlert();
                    this.processorNotifyCondition.await();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        while ((availableSequence = dependentSequence.get()) < sequence2) {
            barrier.checkAlert();
            ThreadHints.onSpinWait();
        }
        return availableSequence;
    }

    @Override
    public void signalAllWhenBlocking() {
        this.lock.lock();
        try {
            this.processorNotifyCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "BlockingWaitStrategy{processorNotifyCondition=" + this.processorNotifyCondition + '}';
    }
}

