/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder.com.lmax.disruptor;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import net.logstash.logback.encoder.com.lmax.disruptor.Cursored;
import net.logstash.logback.encoder.com.lmax.disruptor.Sequence;

class SequenceGroups {
    SequenceGroups() {
    }

    static <T> void addSequences(T holder, AtomicReferenceFieldUpdater<T, Sequence[]> updater, Cursored cursor, Sequence ... sequencesToAdd) {
        long cursorSequence;
        Sequence[] updatedSequences;
        Sequence[] currentSequences;
        do {
            currentSequences = updater.get(holder);
            updatedSequences = Arrays.copyOf(currentSequences, currentSequences.length + sequencesToAdd.length);
            cursorSequence = cursor.getCursor();
            int index = currentSequences.length;
            Sequence[] sequenceArray = sequencesToAdd;
            int n = sequenceArray.length;
            for (int j = 0; j < n; ++j) {
                Sequence sequence2 = sequenceArray[j];
                sequence2.set(cursorSequence);
                updatedSequences[index++] = sequence2;
            }
        } while (!updater.compareAndSet(holder, currentSequences, updatedSequences));
        cursorSequence = cursor.getCursor();
        for (Sequence sequence3 : sequencesToAdd) {
            sequence3.set(cursorSequence);
        }
    }

    static <T> boolean removeSequence(T holder, AtomicReferenceFieldUpdater<T, Sequence[]> sequenceUpdater, Sequence sequence2) {
        Sequence[] oldSequences;
        int numToRemove;
        while (0 != (numToRemove = SequenceGroups.countMatching(oldSequences = sequenceUpdater.get(holder), sequence2))) {
            int oldSize = oldSequences.length;
            Sequence[] newSequences = new Sequence[oldSize - numToRemove];
            int pos = 0;
            for (int i2 = 0; i2 < oldSize; ++i2) {
                Sequence testSequence = oldSequences[i2];
                if (sequence2 == testSequence) continue;
                newSequences[pos++] = testSequence;
            }
            if (!sequenceUpdater.compareAndSet(holder, oldSequences, newSequences)) continue;
        }
        return numToRemove != 0;
    }

    private static <T> int countMatching(T[] values2, T toMatch) {
        int numToRemove = 0;
        for (T value : values2) {
            if (value != toMatch) continue;
            ++numToRemove;
        }
        return numToRemove;
    }
}

