/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.layout;

import ch.qos.logback.core.Layout;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Objects;
import net.logstash.logback.composite.AbstractCompositeJsonFormatter;
import net.logstash.logback.composite.JsonProviders;
import net.logstash.logback.decorate.JsonFactoryDecorator;
import net.logstash.logback.decorate.JsonGeneratorDecorator;
import net.logstash.logback.encoder.SeparatorParser;
import net.logstash.logback.util.ReusableByteBuffer;
import net.logstash.logback.util.ThreadLocalReusableByteBuffer;

public abstract class CompositeJsonLayout<Event extends DeferredProcessingAware>
extends LayoutBase<Event> {
    private boolean immediateFlush = true;
    private Layout<Event> prefix;
    private Layout<Event> suffix;
    private String lineSeparator;
    private int minBufferSize = 1024;
    private ThreadLocalReusableByteBuffer threadLocalBuffer;
    private final AbstractCompositeJsonFormatter<Event> formatter = Objects.requireNonNull(this.createFormatter());

    protected abstract AbstractCompositeJsonFormatter<Event> createFormatter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doLayout(Event event) {
        if (!this.isStarted()) {
            throw new IllegalStateException("Layout is not started");
        }
        ReusableByteBuffer buffer = (ReusableByteBuffer)this.threadLocalBuffer.acquire();
        try {
            this.writeEvent(buffer, event);
            String string = new String(buffer.toByteArray());
            return string;
        }
        catch (IOException e) {
            this.addWarn("Error formatting logging event", e);
            String string = null;
            return string;
        }
        finally {
            this.threadLocalBuffer.release();
        }
    }

    private void writeEvent(OutputStream outputStream2, Event event) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream2);){
            this.writeLayout(this.prefix, writer, event);
            this.formatter.writeEvent(event, outputStream2);
            this.writeLayout(this.suffix, writer, event);
            if (this.lineSeparator != null) {
                writer.write(this.lineSeparator);
            }
            ((Writer)writer).flush();
        }
    }

    private void writeLayout(Layout<Event> wrapped, Writer writer, Event event) throws IOException {
        if (wrapped == null) {
            return;
        }
        String str = wrapped.doLayout(event);
        if (str != null) {
            writer.write(str);
            writer.flush();
        }
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        super.start();
        this.formatter.setContext(this.getContext());
        this.formatter.start();
        this.startWrapped(this.prefix);
        this.startWrapped(this.suffix);
        this.threadLocalBuffer = new ThreadLocalReusableByteBuffer(this.minBufferSize);
    }

    private void startWrapped(Layout<Event> wrapped) {
        if (wrapped instanceof PatternLayoutBase) {
            PatternLayoutBase layout = (PatternLayoutBase)wrapped;
            layout.setPostCompileProcessor(null);
            layout.start();
        }
        if (wrapped != null && !wrapped.isStarted()) {
            wrapped.start();
        }
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        this.formatter.stop();
        this.stopWrapped(this.prefix);
        this.stopWrapped(this.suffix);
        this.threadLocalBuffer = null;
    }

    private void stopWrapped(Layout<Event> wrapped) {
        if (wrapped != null && !wrapped.isStarted()) {
            wrapped.stop();
        }
    }

    public JsonProviders<Event> getProviders() {
        return this.formatter.getProviders();
    }

    public void setProviders(JsonProviders<Event> jsonProviders) {
        this.formatter.setProviders(jsonProviders);
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    public void setImmediateFlush(boolean immediateFlush) {
        this.immediateFlush = immediateFlush;
    }

    public JsonFactoryDecorator getJsonFactoryDecorator() {
        return this.formatter.getJsonFactoryDecorator();
    }

    public void setJsonFactoryDecorator(JsonFactoryDecorator jsonFactoryDecorator) {
        this.formatter.setJsonFactoryDecorator(jsonFactoryDecorator);
    }

    public JsonGeneratorDecorator getJsonGeneratorDecorator() {
        return this.formatter.getJsonGeneratorDecorator();
    }

    public void setJsonGeneratorDecorator(JsonGeneratorDecorator jsonGeneratorDecorator) {
        this.formatter.setJsonGeneratorDecorator(jsonGeneratorDecorator);
    }

    public void setFindAndRegisterJacksonModules(boolean findAndRegisterJacksonModules) {
        this.formatter.setFindAndRegisterJacksonModules(findAndRegisterJacksonModules);
    }

    protected AbstractCompositeJsonFormatter<Event> getFormatter() {
        return this.formatter;
    }

    public Layout<Event> getPrefix() {
        return this.prefix;
    }

    public void setPrefix(Layout<Event> prefix) {
        this.prefix = prefix;
    }

    public Layout<Event> getSuffix() {
        return this.suffix;
    }

    public void setSuffix(Layout<Event> suffix) {
        this.suffix = suffix;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = SeparatorParser.parseSeparator(lineSeparator);
    }

    public int getMinBufferSize() {
        return this.minBufferSize;
    }

    public void setMinBufferSize(int minBufferSize) {
        this.minBufferSize = minBufferSize;
    }
}

