/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.marker;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.logstash.logback.argument.StructuredArgument;
import net.logstash.logback.argument.StructuredArguments;
import net.logstash.logback.marker.LogstashMarker;

public class ObjectFieldsAppendingMarker
extends LogstashMarker
implements StructuredArgument {
    public static final String MARKER_NAME = "LS_OBJECT_FIELDS";
    private final Object object;
    private static final Map<ObjectMapper, SerializerHelper> serializerHelper = new ConcurrentHashMap<ObjectMapper, SerializerHelper>();

    public ObjectFieldsAppendingMarker(Object object) {
        super(MARKER_NAME);
        this.object = object;
    }

    @Override
    public void writeTo(JsonGenerator generator) throws IOException {
        if (this.object != null) {
            SerializerHelper helper = ObjectFieldsAppendingMarker.getSerializerHelper(generator);
            helper.serialize(generator, this.object);
        }
    }

    @Override
    public String toStringSelf() {
        return StructuredArguments.toString(this.object);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ObjectFieldsAppendingMarker)) {
            return false;
        }
        ObjectFieldsAppendingMarker other = (ObjectFieldsAppendingMarker)obj;
        return Objects.equals(this.object, other.object);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + super.hashCode();
        result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
        return result;
    }

    private static SerializerHelper getSerializerHelper(JsonGenerator gen) {
        ObjectMapper mapper = (ObjectMapper)gen.getCodec();
        return serializerHelper.computeIfAbsent(mapper, SerializerHelper::new);
    }

    private static class SerializerHelper {
        private final SerializerProvider serializers;
        private final ConcurrentHashMap<Class<?>, JsonSerializer<Object>> cache = new ConcurrentHashMap();

        SerializerHelper(ObjectMapper mapper) {
            this.serializers = mapper.getSerializerProviderInstance();
        }

        public void serialize(JsonGenerator gen, Object value) throws IOException {
            JsonSerializer<Object> unwrappingSerializer;
            if (value != null && (unwrappingSerializer = this.getUnwrappingSerializer(value.getClass())).isUnwrappingSerializer()) {
                unwrappingSerializer.serialize(value, gen, this.serializers);
            }
        }

        private JsonSerializer<Object> getUnwrappingSerializer(Class<?> type) throws JsonMappingException {
            JsonSerializer<Object> serializer = this.cache.get(type);
            if (serializer == null) {
                serializer = this.createUnwrappingSerializer(type);
                this.cache.put(type, serializer);
            }
            return serializer;
        }

        private JsonSerializer<Object> createUnwrappingSerializer(Class<?> type) throws JsonMappingException {
            JsonSerializer<Object> serializer = this.serializers.findValueSerializer(type);
            return serializer.unwrappingSerializer(NameTransformer.NOP);
        }
    }
}

