/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.mask;

import com.fasterxml.jackson.core.JsonStreamContext;
import java.util.Objects;
import net.logstash.logback.mask.FieldMasker;

public class PathBasedFieldMasker
implements FieldMasker {
    public static final String TOKEN_SEPARATOR = "/";
    public static final String WILDCARD_TOKEN = "*";
    private final boolean isAbsolutePath;
    private final String[] tokens;
    private final Object mask;

    public PathBasedFieldMasker(String pathToMask, Object mask) {
        PathBasedFieldMasker.validatePathToMask(pathToMask);
        this.isAbsolutePath = pathToMask.startsWith(TOKEN_SEPARATOR);
        if (this.isAbsolutePath) {
            pathToMask = pathToMask.substring(TOKEN_SEPARATOR.length());
        }
        this.tokens = pathToMask.split(TOKEN_SEPARATOR);
        for (int i2 = 0; i2 < this.tokens.length; ++i2) {
            this.tokens[i2] = PathBasedFieldMasker.unescapeJsonPointerToken(this.tokens[i2]);
        }
        this.mask = mask;
    }

    static void validatePathToMask(String pathToMask) {
        Objects.requireNonNull(pathToMask, "pathToMask must not be null");
        if (pathToMask.isEmpty()) {
            throw new IllegalArgumentException("pathToMask must not be empty");
        }
        if (pathToMask.equals(TOKEN_SEPARATOR)) {
            throw new IllegalArgumentException("pathToMask must contain at least one token");
        }
    }

    @Override
    public Object mask(JsonStreamContext context) {
        JsonStreamContext currentContext = context;
        int i2 = this.tokens.length;
        while (--i2 >= 0) {
            if (!this.currentLeafMatches(currentContext, this.tokens[i2])) {
                return null;
            }
            currentContext = currentContext.getParent();
        }
        return currentContext != null && (!this.isAbsolutePath || currentContext.inRoot()) ? this.mask : null;
    }

    private boolean currentLeafMatches(JsonStreamContext context, String leafName) {
        if (context != null) {
            if (WILDCARD_TOKEN.equals(leafName)) {
                return true;
            }
            if (context.hasCurrentName()) {
                return context.getCurrentName().equals(leafName);
            }
            if (context.hasCurrentIndex()) {
                return Integer.toString(context.getCurrentIndex()).equals(leafName);
            }
        }
        return false;
    }

    static boolean isSingleFieldName(String path) {
        return !path.contains(TOKEN_SEPARATOR) && !path.contains(WILDCARD_TOKEN);
    }

    static String unescapeJsonPointerToken(String token) {
        return token.replace("~1", TOKEN_SEPARATOR).replace("~0", "~");
    }
}

