/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import nostr.api.EventNostr;
import nostr.api.NIP25;
import nostr.api.factory.impl.GenericEventFactory;
import nostr.base.Kind;
import nostr.event.BaseTag;
import nostr.event.Deleteable;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.AddressTag;
import nostr.event.tag.EventTag;
import nostr.id.Identity;

public class NIP09
extends EventNostr {
    public NIP09(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.setSender(sender);
    }

    public NIP09 createDeletionEvent(Deleteable ... deleteables) {
        if (deleteables == null) {
            throw new NullPointerException("deleteables is marked non-null but is null");
        }
        return this.createDeletionEvent(List.of(deleteables));
    }

    public NIP09 createDeletionEvent(@NonNull List<Deleteable> deleteables) {
        if (deleteables == null) {
            throw new NullPointerException("deleteables is marked non-null but is null");
        }
        List<BaseTag> tags = this.getTags(deleteables);
        GenericEvent genericEvent = new GenericEventFactory<BaseTag>(this.getSender(), Kind.DELETION.getValue(), tags, "").create();
        this.updateEvent(genericEvent);
        return this;
    }

    private List<BaseTag> getTags(List<Deleteable> deleteables) {
        ArrayList<BaseTag> tags = new ArrayList<BaseTag>();
        for (Deleteable d : deleteables) {
            if (d instanceof GenericEvent) {
                GenericEvent event = (GenericEvent)d;
                tags.add(new EventTag(event.getId()));
                event.getTags().stream().filter(tag -> tag instanceof AddressTag).map(AddressTag.class::cast).forEach(tag -> {
                    tags.add((BaseTag)tag);
                    tags.add(NIP25.createKindTag(tag.getKind()));
                });
            }
            tags.add(NIP25.createKindTag(d.getKind()));
        }
        return tags;
    }
}

