/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import lombok.NonNull;
import nostr.api.EventNostr;
import nostr.api.NIP01;
import nostr.api.NIP12;
import nostr.api.factory.impl.BaseTagFactory;
import nostr.api.factory.impl.GenericEventFactory;
import nostr.base.Kind;
import nostr.base.Relay;
import nostr.event.BaseTag;
import nostr.event.entities.Reaction;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.EmojiTag;
import nostr.event.tag.EventTag;
import nostr.id.Identity;

public class NIP25
extends EventNostr {
    public NIP25(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.setSender(sender);
    }

    public NIP25 createReactionEvent(@NonNull GenericEvent event, @NonNull Reaction reaction, Relay relay) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (reaction == null) {
            throw new NullPointerException("reaction is marked non-null but is null");
        }
        return this.createReactionEvent(event, reaction.getEmoji(), relay);
    }

    public NIP25 createReactionEvent(@NonNull GenericEvent event, @NonNull String content, Relay relay) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), Kind.REACTION.getValue(), content).create();
        if (event.isAddressable()) {
            genericEvent.addTag(NIP01.createAddressTag(event.getKind(), event.getPubKey(), event.getId()));
            genericEvent.addTag(NIP25.createKindTag(event.getKind()));
        } else {
            genericEvent.addTag(NIP01.createEventTag(event.getId(), relay != null ? relay.toString() : null, null));
            genericEvent.addTag(NIP01.createPubKeyTag(event.getPubKey()));
        }
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP25 createReactionToWebsiteEvent(@NonNull URL url, @NonNull Reaction reaction) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (reaction == null) {
            throw new NullPointerException("reaction is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), Kind.REACTION_TO_WEBSITE.getValue(), reaction.getEmoji()).create();
        genericEvent.addTag(NIP12.createReferenceTag(url));
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP25 createReactionEvent(@NonNull BaseTag eventTag, @NonNull BaseTag emojiTag) {
        if (eventTag == null) {
            throw new NullPointerException("eventTag is marked non-null but is null");
        }
        if (emojiTag == null) {
            throw new NullPointerException("emojiTag is marked non-null but is null");
        }
        if (!(emojiTag instanceof EmojiTag)) {
            throw new IllegalArgumentException("The tag is not a custom emoji tag");
        }
        if (!(eventTag instanceof EventTag)) {
            throw new IllegalArgumentException("The tag is not an event tag");
        }
        String shortCode = ((EmojiTag)emojiTag).getShortcode();
        String content = String.format(":%s:", shortCode);
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), Kind.REACTION.getValue(), content).create();
        genericEvent.addTag(emojiTag);
        genericEvent.addTag(eventTag);
        this.updateEvent(genericEvent);
        return this;
    }

    public static BaseTag createKindTag(@NonNull Integer kind) {
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        return new BaseTagFactory("k", kind.toString()).create();
    }

    public static BaseTag createCustomEmojiTag(@NonNull String shortcode, @NonNull URL url) {
        if (shortcode == null) {
            throw new NullPointerException("shortcode is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return new BaseTagFactory("emoji", shortcode, url.toString()).create();
    }

    public static BaseTag createCustomEmojiTag(@NonNull String shortcode, @NonNull String url) {
        if (shortcode == null) {
            throw new NullPointerException("shortcode is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        try {
            return NIP25.createCustomEmojiTag(shortcode, URI.create(url).toURL());
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid custom emoji URL: " + url, ex);
        }
    }

    public void like(@NonNull GenericEvent event, Relay relay) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.react(event, Reaction.LIKE.getEmoji(), relay);
    }

    public void like(@NonNull GenericEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.react(event, Reaction.LIKE.getEmoji(), null);
    }

    public void dislike(@NonNull GenericEvent event, Relay relay) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.react(event, Reaction.DISLIKE.getEmoji(), relay);
    }

    public void dislike(@NonNull GenericEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.react(event, Reaction.DISLIKE.getEmoji(), null);
    }

    public void react(@NonNull GenericEvent event, @NonNull String reaction, Relay relay) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (reaction == null) {
            throw new NullPointerException("reaction is marked non-null but is null");
        }
        GenericEvent e = this.createReactionEvent(event, reaction, relay).getEvent();
        this.updateEvent(e);
        this.sign().send();
    }
}

