/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.util.ArrayList;
import lombok.NonNull;
import nostr.api.EventNostr;
import nostr.api.factory.impl.BaseTagFactory;
import nostr.api.factory.impl.GenericEventFactory;
import nostr.base.Command;
import nostr.base.ElementAttribute;
import nostr.base.Kind;
import nostr.base.Relay;
import nostr.event.BaseTag;
import nostr.event.impl.CanonicalAuthenticationEvent;
import nostr.event.impl.GenericEvent;
import nostr.event.message.CanonicalAuthenticationMessage;
import nostr.event.message.GenericMessage;

public class NIP42
extends EventNostr {
    public NIP42 createCanonicalAuthenticationEvent(@NonNull String challenge, @NonNull Relay relay) {
        if (challenge == null) {
            throw new NullPointerException("challenge is marked non-null but is null");
        }
        if (relay == null) {
            throw new NullPointerException("relay is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), Kind.CLIENT_AUTH.getValue(), "").create();
        this.updateEvent(genericEvent);
        this.addChallengeTag(challenge);
        this.addRelayTag(relay);
        return this;
    }

    public NIP42 addRelayTag(@NonNull Relay relay) {
        if (relay == null) {
            throw new NullPointerException("relay is marked non-null but is null");
        }
        BaseTag tag = NIP42.createRelayTag(relay);
        this.getEvent().addTag(tag);
        return this;
    }

    public NIP42 addChallengeTag(@NonNull String challenge) {
        if (challenge == null) {
            throw new NullPointerException("challenge is marked non-null but is null");
        }
        BaseTag tag = NIP42.createChallengeTag(challenge);
        this.getEvent().addTag(tag);
        return this;
    }

    public static BaseTag createRelayTag(@NonNull Relay relay) {
        if (relay == null) {
            throw new NullPointerException("relay is marked non-null but is null");
        }
        return new BaseTagFactory("relay", relay.getUri()).create();
    }

    public static BaseTag createChallengeTag(@NonNull String challenge) {
        if (challenge == null) {
            throw new NullPointerException("challenge is marked non-null but is null");
        }
        return new BaseTagFactory("challenge", challenge).create();
    }

    public static CanonicalAuthenticationMessage createClientAuthenticationMessage(@NonNull CanonicalAuthenticationEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        return new CanonicalAuthenticationMessage(event);
    }

    public static GenericMessage createRelayAuthenticationMessage(@NonNull String challenge) {
        if (challenge == null) {
            throw new NullPointerException("challenge is marked non-null but is null");
        }
        ArrayList<ElementAttribute> attributes = new ArrayList<ElementAttribute>();
        ElementAttribute attr = new ElementAttribute("challenge", challenge);
        attributes.add(attr);
        return new GenericMessage(Command.AUTH.name(), attributes);
    }
}

