/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.IEvent;
import nostr.base.RelayUri;
import nostr.base.SubscriptionId;
import nostr.client.WebSocketClientFactory;
import nostr.client.springwebsocket.SpringWebSocketClient;
import nostr.client.springwebsocket.SpringWebSocketClientFactory;
import nostr.event.filter.Filters;
import nostr.event.impl.GenericEvent;
import nostr.event.message.CloseMessage;
import nostr.event.message.EventMessage;
import nostr.event.message.ReqMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClientHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebSocketClientHandler.class);
    private final SpringWebSocketClient eventClient;
    private final Map<SubscriptionId, SpringWebSocketClient> requestClientMap = new ConcurrentHashMap<SubscriptionId, SpringWebSocketClient>();
    private final Function<SubscriptionId, SpringWebSocketClient> requestClientFactory;
    private final WebSocketClientFactory clientFactory;
    private final String relayName;
    private final RelayUri relayUri;

    protected WebSocketClientHandler(@NonNull String relayName, @NonNull String relayUri) throws ExecutionException, InterruptedException {
        this(relayName, new RelayUri(relayUri), new SpringWebSocketClientFactory());
        if (relayName == null) {
            throw new NullPointerException("relayName is marked non-null but is null");
        }
        if (relayUri == null) {
            throw new NullPointerException("relayUri is marked non-null but is null");
        }
    }

    protected WebSocketClientHandler(@NonNull String relayName, @NonNull RelayUri relayUri, @NonNull WebSocketClientFactory clientFactory) throws ExecutionException, InterruptedException {
        this(relayName, relayUri, new SpringWebSocketClient(clientFactory.create(relayUri), relayUri.toString()), null, null, clientFactory);
        if (relayName == null) {
            throw new NullPointerException("relayName is marked non-null but is null");
        }
        if (relayUri == null) {
            throw new NullPointerException("relayUri is marked non-null but is null");
        }
        if (clientFactory == null) {
            throw new NullPointerException("clientFactory is marked non-null but is null");
        }
    }

    public WebSocketClientHandler(@NonNull String relayName, @NonNull RelayUri relayUri, @NonNull SpringWebSocketClient eventClient, Map<SubscriptionId, SpringWebSocketClient> requestClients, Function<SubscriptionId, SpringWebSocketClient> requestClientFactory, @NonNull WebSocketClientFactory clientFactory) {
        if (relayName == null) {
            throw new NullPointerException("relayName is marked non-null but is null");
        }
        if (relayUri == null) {
            throw new NullPointerException("relayUri is marked non-null but is null");
        }
        if (eventClient == null) {
            throw new NullPointerException("eventClient is marked non-null but is null");
        }
        if (clientFactory == null) {
            throw new NullPointerException("clientFactory is marked non-null but is null");
        }
        this.relayName = relayName;
        this.relayUri = relayUri;
        this.eventClient = eventClient;
        this.clientFactory = clientFactory;
        Function<SubscriptionId, SpringWebSocketClient> function = this.requestClientFactory = requestClientFactory != null ? requestClientFactory : key -> this.createRequestClient();
        if (requestClients != null) {
            this.requestClientMap.putAll(requestClients);
        }
    }

    public List<String> sendEvent(@NonNull IEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        ((GenericEvent)event).validate();
        try {
            return this.eventClient.send(new EventMessage(event)).stream().toList();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to send event", e);
        }
    }

    public List<String> sendRequest(@NonNull Filters filters, @NonNull SubscriptionId subscriptionId) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        try {
            SpringWebSocketClient client = this.getOrCreateRequestClient(subscriptionId);
            return client.send(new ReqMessage(subscriptionId.value(), filters));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to send request", e);
        }
    }

    public AutoCloseable subscribe(@NonNull Filters filters, @NonNull String subscriptionId, @NonNull Consumer<String> listener, Consumer<Throwable> errorListener) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        SubscriptionId id = SubscriptionId.of(subscriptionId);
        SpringWebSocketClient client = this.getOrCreateRequestClient(id);
        Consumer<Throwable> safeError = this.resolveErrorListener(id, errorListener);
        AutoCloseable delegate = this.openSubscription(client, filters, id, listener, safeError);
        return new SubscriptionHandle(id, client, delegate, safeError);
    }

    private Consumer<Throwable> resolveErrorListener(SubscriptionId subscriptionId, Consumer<Throwable> errorListener) {
        if (errorListener != null) {
            return errorListener;
        }
        return throwable -> log.warn("Subscription error on relay {} for {}", this.relayName, subscriptionId.value(), throwable);
    }

    private AutoCloseable openSubscription(SpringWebSocketClient client, Filters filters, SubscriptionId subscriptionId, Consumer<String> listener, Consumer<Throwable> errorListener) {
        try {
            return client.subscribe(new ReqMessage(subscriptionId.value(), filters), listener, errorListener, () -> errorListener.accept(new IOException("Subscription closed by relay %s for id %s".formatted(this.relayName, subscriptionId.value()))));
        }
        catch (IOException e) {
            errorListener.accept(e);
            throw new RuntimeException("Failed to establish subscription", e);
        }
    }

    private void closeQuietly(AutoCloseable closeable, CloseAccumulator accumulator) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            accumulator.record(e);
        }
        catch (Exception e) {
            accumulator.record(e);
        }
    }

    public void close() throws IOException {
        this.eventClient.close();
        for (SpringWebSocketClient client : this.requestClientMap.values()) {
            client.close();
        }
    }

    protected SpringWebSocketClient getOrCreateRequestClient(SubscriptionId subscriptionId) {
        try {
            return this.requestClientMap.computeIfAbsent(subscriptionId, this.requestClientFactory);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw e;
        }
    }

    private SpringWebSocketClient createRequestClient() {
        try {
            return new SpringWebSocketClient(this.clientFactory.create(this.relayUri), this.relayUri.toString());
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to initialize request client", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while initializing request client", e);
        }
    }

    @Generated
    public String getRelayName() {
        return this.relayName;
    }

    @Generated
    public RelayUri getRelayUri() {
        return this.relayUri;
    }

    private final class SubscriptionHandle
    implements AutoCloseable {
        private final SubscriptionId subscriptionId;
        private final SpringWebSocketClient client;
        private final AutoCloseable delegate;
        private final Consumer<Throwable> errorListener;

        private SubscriptionHandle(SubscriptionId subscriptionId, SpringWebSocketClient client, AutoCloseable delegate, Consumer<Throwable> errorListener) {
            this.subscriptionId = subscriptionId;
            this.client = client;
            this.delegate = delegate;
            this.errorListener = errorListener;
        }

        @Override
        public void close() throws IOException {
            CloseAccumulator accumulator = new CloseAccumulator(this.errorListener);
            AutoCloseable closeFrameHandle = this.openCloseFrame(this.subscriptionId, accumulator);
            WebSocketClientHandler.this.closeQuietly(closeFrameHandle, accumulator);
            WebSocketClientHandler.this.closeQuietly(this.delegate, accumulator);
            WebSocketClientHandler.this.closeQuietly(this.client, accumulator);
            WebSocketClientHandler.this.requestClientMap.remove(this.subscriptionId);
            accumulator.rethrowIfNecessary();
        }

        private AutoCloseable openCloseFrame(SubscriptionId subscriptionId, CloseAccumulator accumulator) {
            try {
                return this.client.subscribe(new CloseMessage(subscriptionId.value()), message -> {}, this.errorListener, null);
            }
            catch (IOException e) {
                accumulator.record(e);
                return null;
            }
        }
    }

    private static final class CloseAccumulator {
        private final Consumer<Throwable> errorListener;
        private IOException ioFailure;
        private Exception nonIoFailure;

        private CloseAccumulator(Consumer<Throwable> errorListener) {
            this.errorListener = errorListener;
        }

        private void record(IOException exception) {
            this.errorListener.accept(exception);
            if (this.ioFailure == null) {
                this.ioFailure = exception;
            }
        }

        private void record(Exception exception) {
            this.errorListener.accept(exception);
            if (this.nonIoFailure == null) {
                this.nonIoFailure = exception;
            }
        }

        private void rethrowIfNecessary() throws IOException {
            if (this.ioFailure != null) {
                throw this.ioFailure;
            }
            if (this.nonIoFailure != null) {
                throw new IOException("Failed to close subscription cleanly", this.nonIoFailure);
            }
        }
    }
}

