/*
 * Decompiled with CFR 0.152.
 */
package nostr.api.client;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import nostr.api.client.NostrRelayRegistry;
import nostr.base.SubscriptionId;
import nostr.client.springwebsocket.SpringWebSocketClient;
import nostr.event.filter.Filters;
import nostr.event.message.ReqMessage;

public final class NostrRequestDispatcher {
    private final NostrRelayRegistry relayRegistry;

    public NostrRequestDispatcher(NostrRelayRegistry relayRegistry) {
        this.relayRegistry = relayRegistry;
    }

    public List<String> sendRequest(@NonNull Filters filters, @NonNull String subscriptionId) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        return this.sendRequest(filters, SubscriptionId.of(subscriptionId));
    }

    public List<String> sendRequest(@NonNull Filters filters, @NonNull SubscriptionId subscriptionId) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        this.relayRegistry.ensureRequestClients(subscriptionId);
        return this.relayRegistry.requestHandlers(subscriptionId).stream().map(handler -> handler.sendRequest(filters, subscriptionId)).flatMap(Collection::stream).toList();
    }

    public List<String> sendRequest(@NonNull List<Filters> filtersList, @NonNull String subscriptionId) {
        if (filtersList == null) {
            throw new NullPointerException("filtersList is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        SubscriptionId id = SubscriptionId.of(subscriptionId);
        return filtersList.stream().map(filters -> this.sendRequest((Filters)filters, id)).flatMap(Collection::stream).distinct().toList();
    }

    public static List<String> sendRequest(@NonNull SpringWebSocketClient client, @NonNull Filters filters, @NonNull String subscriptionId) throws IOException {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        return client.send(new ReqMessage(subscriptionId, filters));
    }
}

