/*
 * Decompiled with CFR 0.152.
 */
package nostr.api.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import lombok.NonNull;
import nostr.api.WebSocketClientHandler;
import nostr.api.client.NostrRelayRegistry;
import nostr.base.SubscriptionId;
import nostr.event.filter.Filters;

public final class NostrSubscriptionManager {
    private final NostrRelayRegistry relayRegistry;

    public NostrSubscriptionManager(NostrRelayRegistry relayRegistry) {
        this.relayRegistry = relayRegistry;
    }

    public AutoCloseable subscribe(@NonNull Filters filters, @NonNull String subscriptionId, @NonNull Consumer<String> listener, @NonNull Consumer<Throwable> errorConsumer) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (errorConsumer == null) {
            throw new NullPointerException("errorConsumer is marked non-null but is null");
        }
        SubscriptionId id = SubscriptionId.of(subscriptionId);
        ArrayList<AutoCloseable> handles = new ArrayList<AutoCloseable>();
        try {
            for (WebSocketClientHandler handler : this.relayRegistry.baseHandlers()) {
                AutoCloseable handle2 = handler.subscribe(filters, id.value(), listener, errorConsumer);
                handles.add(handle2);
            }
        }
        catch (RuntimeException e) {
            this.closeQuietly(handles, errorConsumer);
            throw e;
        }
        return () -> this.closeHandles(handles, errorConsumer);
    }

    private void closeHandles(List<AutoCloseable> handles, Consumer<Throwable> errorConsumer) throws IOException {
        IOException ioFailure = null;
        Exception nonIoFailure = null;
        for (AutoCloseable handle2 : handles) {
            try {
                handle2.close();
            }
            catch (IOException e) {
                errorConsumer.accept(e);
                if (ioFailure != null) continue;
                ioFailure = e;
            }
            catch (Exception e) {
                errorConsumer.accept(e);
                nonIoFailure = e;
            }
        }
        if (ioFailure != null) {
            throw ioFailure;
        }
        if (nonIoFailure != null) {
            throw new IOException("Failed to close subscription", nonIoFailure);
        }
    }

    private void closeQuietly(List<AutoCloseable> handles, Consumer<Throwable> errorConsumer) {
        for (AutoCloseable handle2 : handles) {
            try {
                handle2.close();
            }
            catch (Exception closeEx) {
                errorConsumer.accept(closeEx);
            }
        }
    }
}

