/*
 * Decompiled with CFR 0.152.
 */
package nostr.api.factory.impl;

import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import nostr.api.factory.BaseMessageFactory;
import nostr.event.impl.GenericEvent;
import nostr.event.message.EventMessage;

public class EventMessageFactory
extends BaseMessageFactory<EventMessage> {
    private final GenericEvent event;
    private String subscriptionId;

    public EventMessageFactory(@NonNull GenericEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    public EventMessageFactory(@NonNull GenericEvent event, @NonNull String subscriptionId) {
        this(event);
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        this.subscriptionId = subscriptionId;
    }

    @Override
    public EventMessage create() {
        return Optional.ofNullable(this.subscriptionId).map(subscriptionId -> new EventMessage(this.event, (String)subscriptionId)).orElse(new EventMessage(this.event));
    }

    @Generated
    public GenericEvent getEvent() {
        return this.event;
    }

    @Generated
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Generated
    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    @Generated
    public String toString() {
        return "EventMessageFactory(event=" + String.valueOf(this.getEvent()) + ", subscriptionId=" + this.getSubscriptionId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventMessageFactory)) {
            return false;
        }
        EventMessageFactory other = (EventMessageFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GenericEvent this$event = this.getEvent();
        GenericEvent other$event = other.getEvent();
        if (this$event == null ? other$event != null : !((Object)this$event).equals(other$event)) {
            return false;
        }
        String this$subscriptionId = this.getSubscriptionId();
        String other$subscriptionId = other.getSubscriptionId();
        return !(this$subscriptionId == null ? other$subscriptionId != null : !this$subscriptionId.equals(other$subscriptionId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EventMessageFactory;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GenericEvent $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : ((Object)$event).hashCode());
        String $subscriptionId = this.getSubscriptionId();
        result = result * 59 + ($subscriptionId == null ? 43 : $subscriptionId.hashCode());
        return result;
    }
}

