/*
 * Decompiled with CFR 0.152.
 */
package nostr.api.nip01;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import nostr.api.factory.impl.BaseTagFactory;
import nostr.base.Marker;
import nostr.base.PublicKey;
import nostr.base.Relay;
import nostr.event.BaseTag;
import nostr.event.tag.IdentifierTag;

public final class NIP01TagFactory {
    private NIP01TagFactory() {
    }

    public static BaseTag eventTag(@NonNull String relatedEventId) {
        if (relatedEventId == null) {
            throw new NullPointerException("relatedEventId is marked non-null but is null");
        }
        return new BaseTagFactory("e", List.of(relatedEventId)).create();
    }

    public static BaseTag eventTag(@NonNull String idEvent, String recommendedRelayUrl, Marker marker) {
        if (idEvent == null) {
            throw new NullPointerException("idEvent is marked non-null but is null");
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(idEvent);
        if (recommendedRelayUrl != null) {
            params.add(recommendedRelayUrl);
        }
        if (marker != null) {
            params.add(marker.getValue());
        }
        return new BaseTagFactory("e", params).create();
    }

    public static BaseTag eventTag(@NonNull String idEvent, Marker marker) {
        if (idEvent == null) {
            throw new NullPointerException("idEvent is marked non-null but is null");
        }
        return NIP01TagFactory.eventTag(idEvent, (String)null, marker);
    }

    public static BaseTag eventTag(@NonNull String idEvent, Relay recommendedRelay, Marker marker) {
        if (idEvent == null) {
            throw new NullPointerException("idEvent is marked non-null but is null");
        }
        return NIP01TagFactory.eventTag(idEvent, recommendedRelay != null ? recommendedRelay.getUri() : null, marker);
    }

    public static BaseTag pubKeyTag(@NonNull PublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return new BaseTagFactory("p", List.of(publicKey.toString())).create();
    }

    public static BaseTag pubKeyTag(@NonNull PublicKey publicKey, String mainRelayUrl, String petName) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(publicKey.toString());
        params.add(mainRelayUrl);
        params.add(petName);
        return new BaseTagFactory("p", params).create();
    }

    public static BaseTag pubKeyTag(@NonNull PublicKey publicKey, String mainRelayUrl) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(publicKey.toString());
        params.add(mainRelayUrl);
        return new BaseTagFactory("p", params).create();
    }

    public static BaseTag identifierTag(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return new BaseTagFactory("d", List.of(id)).create();
    }

    public static BaseTag addressTag(@NonNull Integer kind, @NonNull PublicKey publicKey, BaseTag idTag, Relay relay) {
        IdentifierTag identifierTag;
        String uuid;
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        if (idTag != null && !(idTag instanceof IdentifierTag)) {
            throw new IllegalArgumentException("idTag must be an identifier tag");
        }
        ArrayList<String> params = new ArrayList<String>();
        String param = kind + ":" + String.valueOf(publicKey) + ":";
        if (idTag instanceof IdentifierTag && (uuid = (identifierTag = (IdentifierTag)idTag).getUuid()) != null) {
            param = param + uuid;
        }
        params.add(param);
        if (relay != null) {
            params.add(relay.getUri());
        }
        return new BaseTagFactory("a", params).create();
    }

    public static BaseTag addressTag(@NonNull Integer kind, @NonNull PublicKey publicKey, String id, Relay relay) {
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return NIP01TagFactory.addressTag(kind, publicKey, NIP01TagFactory.identifierTag(id), relay);
    }

    public static BaseTag addressTag(@NonNull Integer kind, @NonNull PublicKey publicKey, String id) {
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return NIP01TagFactory.addressTag(kind, publicKey, NIP01TagFactory.identifierTag(id), null);
    }
}

