/*
 * Decompiled with CFR 0.152.
 */
package nostr.api.nip57;

import java.math.BigInteger;
import java.util.Locale;

public final class Bolt11Util {
    private Bolt11Util() {
    }

    public static long parseMsat(String bolt11) {
        int i2;
        String amountPart;
        int idx;
        if (bolt11 == null || bolt11.isBlank()) {
            throw new IllegalArgumentException("bolt11 invoice is required");
        }
        String lower = bolt11.toLowerCase(Locale.ROOT);
        int sep = lower.lastIndexOf(49);
        if (!lower.startsWith("ln") || sep < 0) {
            throw new IllegalArgumentException("Invalid BOLT11 invoice: missing HRP separator");
        }
        String hrp = lower.substring(2, sep);
        for (idx = 0; idx < hrp.length() && Character.isAlphabetic(hrp.charAt(idx)); ++idx) {
        }
        String string = amountPart = idx < hrp.length() ? hrp.substring(idx) : "";
        if (amountPart.isEmpty()) {
            return -1L;
        }
        for (i2 = 0; i2 < amountPart.length() && Character.isDigit(amountPart.charAt(i2)); ++i2) {
        }
        if (i2 == 0) {
            throw new IllegalArgumentException("Invalid BOLT11 amount");
        }
        long value = Long.parseLong(amountPart.substring(0, i2));
        int exponent = 11;
        if (i2 < amountPart.length()) {
            char unit = amountPart.charAt(i2);
            exponent += (switch (unit) {
                case 'm' -> -3;
                case 'u' -> -6;
                case 'n' -> -9;
                case 'p' -> -12;
                default -> throw new IllegalArgumentException("Unsupported BOLT11 unit: " + unit);
            });
        }
        BigInteger msat = BigInteger.valueOf(value);
        msat = exponent >= 0 ? msat.multiply(BigInteger.TEN.pow(exponent)) : msat.divide(BigInteger.TEN.pow(-exponent));
        if (msat.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            throw new IllegalArgumentException("BOLT11 amount exceeds supported range");
        }
        return msat.longValue();
    }
}

