/*
 * Decompiled with CFR 0.152.
 */
package nostr.base;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.IKey;
import nostr.base.KeyEncodingException;
import nostr.base.KeyType;
import nostr.crypto.bech32.Bech32;
import nostr.crypto.bech32.Bech32EncodingException;
import nostr.crypto.bech32.Bech32Prefix;
import nostr.util.NostrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseKey
implements IKey {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseKey.class);
    @NonNull
    protected final KeyType type;
    @NonNull
    protected final byte[] rawData;
    protected final Bech32Prefix prefix;

    @Override
    public String toBech32String() {
        try {
            return Bech32.toBech32(this.prefix, this.rawData);
        }
        catch (IllegalArgumentException ex) {
            log.error("Invalid key data for Bech32 conversion for {} key with prefix {}", new Object[]{this.type, this.prefix, ex});
            throw new KeyEncodingException("Invalid key data for Bech32 conversion", ex);
        }
        catch (Bech32EncodingException ex) {
            log.error("Failed to convert {} key to Bech32 format with prefix {}", new Object[]{this.type, this.prefix, ex});
            throw new KeyEncodingException("Failed to convert key to Bech32", ex);
        }
    }

    @JsonValue
    public String toString() {
        return this.toHexString();
    }

    public String toHexString() {
        return NostrUtil.bytesToHex(this.rawData);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.type.hashCode();
        hash = 31 * hash + (this.prefix == null ? 0 : this.prefix.hashCode());
        hash = 31 * hash + (this.rawData == null ? 0 : Arrays.hashCode(this.rawData));
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        BaseKey baseKey = (BaseKey)o;
        return Arrays.equals(this.rawData, baseKey.rawData);
    }

    @Generated
    public BaseKey(@NonNull KeyType type, @NonNull byte[] rawData, Bech32Prefix prefix) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (rawData == null) {
            throw new NullPointerException("rawData is marked non-null but is null");
        }
        this.type = type;
        this.rawData = rawData;
        this.prefix = prefix;
    }

    @NonNull
    @Generated
    public KeyType getType() {
        return this.type;
    }

    @Override
    @NonNull
    @Generated
    public byte[] getRawData() {
        return this.rawData;
    }

    @Generated
    public Bech32Prefix getPrefix() {
        return this.prefix;
    }
}

