/*
 * Decompiled with CFR 0.152.
 */
package nostr.base;

import java.net.URI;
import lombok.Generated;
import lombok.NonNull;

public final class RelayUri {
    private final String value;

    public RelayUri(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        try {
            URI uri = URI.create(value);
            String scheme = uri.getScheme();
            if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
                throw new IllegalArgumentException("Relay URI must use ws or wss scheme");
            }
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Invalid relay URI: " + value, ex);
        }
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public URI toUri() {
        return URI.create(this.value);
    }

    public String toString() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelayUri)) {
            return false;
        }
        RelayUri other = (RelayUri)o;
        String this$value = this.value;
        String other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

