/*
 * Decompiled with CFR 0.152.
 */
package nostr.crypto.bech32;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import nostr.crypto.bech32.Bech32EncodingException;
import nostr.crypto.bech32.Bech32Prefix;
import nostr.util.NostrUtil;

public class Bech32 {
    private static final String CHARSET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
    private static final byte[] CHARSET_REV = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15, -1, 10, 17, 21, 20, 26, 30, 7, 5, -1, -1, -1, -1, -1, -1, -1, 29, -1, 24, 13, 25, 9, 8, 23, -1, 18, 22, 31, 27, 19, -1, 1, 0, 3, 16, 11, 28, 12, 14, 6, 4, 2, -1, -1, -1, -1, -1, -1, 29, -1, 24, 13, 25, 9, 8, 23, -1, 18, 22, 31, 27, 19, -1, 1, 0, 3, 16, 11, 28, 12, 14, 6, 4, 2, -1, -1, -1, -1, -1};
    private static final int BECH32_CONST = 1;
    private static final int BECH32M_CONST = 734539939;

    public static String toBech32(Bech32Prefix hrp, byte[] hexKey) {
        try {
            byte[] data = Bech32.convertBits(hexKey, 8, 5, true);
            return Bech32.encode(Encoding.BECH32, hrp.getCode(), data);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Bech32EncodingException("Failed to encode key to Bech32", e);
        }
    }

    public static String toBech32(Bech32Prefix hrp, String hexKey) {
        byte[] data = NostrUtil.hexToBytes(hexKey);
        return Bech32.toBech32(hrp, data);
    }

    public static String fromBech32(String strBech32) throws Exception {
        byte[] data = Bech32.decode((String)strBech32).data;
        if ((data = Bech32.convertBits(data, 5, 8, true)) == null) {
            throw new RuntimeException("Invalid null data");
        }
        data = Arrays.copyOfRange(data, 0, data.length - 1);
        return NostrUtil.bytesToHex(data);
    }

    public static String encode(Bech32Data bech32) throws Exception {
        return Bech32.encode(bech32.encoding, bech32.hrp, bech32.data);
    }

    public static String encode(Encoding encoding, String hrp, byte[] values2) throws Exception {
        if (hrp.isEmpty()) {
            throw new Exception("Human-readable part is too short");
        }
        hrp = hrp.toLowerCase(Locale.ROOT);
        byte[] checksum = Bech32.createChecksum(encoding, hrp, values2);
        byte[] combined = new byte[values2.length + checksum.length];
        System.arraycopy(values2, 0, combined, 0, values2.length);
        System.arraycopy(checksum, 0, combined, values2.length, checksum.length);
        StringBuilder sb = new StringBuilder(hrp.length() + 1 + combined.length);
        sb.append(hrp);
        sb.append('1');
        for (byte b : combined) {
            sb.append(CHARSET.charAt(b));
        }
        return sb.toString();
    }

    public static Bech32Data decode(String str) throws Exception {
        boolean lower = false;
        boolean upper = false;
        if (str.length() < 8) {
            throw new Exception("Input too short: " + str.length());
        }
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char c = str.charAt(i2);
            if (c < '!' || c > '~') {
                throw new Exception(String.format("Invalid Character %c, %d", Character.valueOf(c), i2));
            }
            if (c >= 'a' && c <= 'z') {
                if (upper) {
                    throw new Exception(String.format("Invalid Character %c, %d", Character.valueOf(c), i2));
                }
                lower = true;
            }
            if (c < 'A' || c > 'Z') continue;
            if (lower) {
                throw new Exception(String.format("Invalid Character %c, %d", Character.valueOf(c), i2));
            }
            upper = true;
        }
        int pos = str.lastIndexOf(49);
        if (pos < 1) {
            throw new Exception("Missing human-readable part");
        }
        int dataPartLength = str.length() - 1 - pos;
        if (dataPartLength < 6) {
            throw new Exception(String.format("Data part too short: %d)", dataPartLength));
        }
        byte[] values2 = new byte[dataPartLength];
        for (int i3 = 0; i3 < dataPartLength; ++i3) {
            char c = str.charAt(i3 + pos + 1);
            if (CHARSET_REV[c] == -1) {
                throw new Exception(String.format("Invalid Character %c, %d", Character.valueOf(c), i3 + pos + 1));
            }
            values2[i3] = CHARSET_REV[c];
        }
        String hrp = str.substring(0, pos).toLowerCase(Locale.ROOT);
        Encoding encoding = Bech32.verifyChecksum(hrp, values2);
        if (encoding == null) {
            throw new Exception("InvalidChecksum");
        }
        return new Bech32Data(encoding, hrp, Arrays.copyOfRange(values2, 0, values2.length - 6));
    }

    private static int polymod(byte[] values2) {
        int c = 1;
        for (byte v_i : values2) {
            int c0 = c >>> 25 & 0xFF;
            c = (c & 0x1FFFFFF) << 5 ^ v_i & 0xFF;
            if ((c0 & 1) != 0) {
                c ^= 0x3B6A57B2;
            }
            if ((c0 & 2) != 0) {
                c ^= 0x26508E6D;
            }
            if ((c0 & 4) != 0) {
                c ^= 0x1EA119FA;
            }
            if ((c0 & 8) != 0) {
                c ^= 0x3D4233DD;
            }
            if ((c0 & 0x10) == 0) continue;
            c ^= 0x2A1462B3;
        }
        return c;
    }

    private static byte[] expandHrp(String hrp) {
        int hrpLength = hrp.length();
        byte[] ret = new byte[hrpLength * 2 + 1];
        for (int i2 = 0; i2 < hrpLength; ++i2) {
            int c = hrp.charAt(i2) & 0x7F;
            ret[i2] = (byte)(c >>> 5 & 7);
            ret[i2 + hrpLength + 1] = (byte)(c & 0x1F);
        }
        ret[hrpLength] = 0;
        return ret;
    }

    private static Encoding verifyChecksum(String hrp, byte[] values2) {
        byte[] hrpExpanded = Bech32.expandHrp(hrp);
        byte[] combined = new byte[hrpExpanded.length + values2.length];
        System.arraycopy(hrpExpanded, 0, combined, 0, hrpExpanded.length);
        System.arraycopy(values2, 0, combined, hrpExpanded.length, values2.length);
        int check2 = Bech32.polymod(combined);
        return switch (check2) {
            case 1 -> Encoding.BECH32;
            case 734539939 -> Encoding.BECH32M;
            default -> null;
        };
    }

    private static byte[] createChecksum(Encoding encoding, String hrp, byte[] values2) {
        byte[] hrpExpanded = Bech32.expandHrp(hrp);
        byte[] enc = new byte[hrpExpanded.length + values2.length + 6];
        System.arraycopy(hrpExpanded, 0, enc, 0, hrpExpanded.length);
        System.arraycopy(values2, 0, enc, hrpExpanded.length, values2.length);
        int mod = Bech32.polymod(enc) ^ (encoding == Encoding.BECH32 ? 1 : 734539939);
        byte[] ret = new byte[6];
        for (int i2 = 0; i2 < 6; ++i2) {
            ret[i2] = (byte)(mod >>> 5 * (5 - i2) & 0x1F);
        }
        return ret;
    }

    private static byte[] convertBits(byte[] data, int fromWidth, int toWidth, boolean pad) {
        int acc = 0;
        int bits = 0;
        ArrayList<Byte> result = new ArrayList<Byte>();
        for (int i2 = 0; i2 < data.length; ++i2) {
            int value = data[i2] & 0xFF & (1 << fromWidth) - 1;
            acc = acc << fromWidth | value;
            bits += fromWidth;
            while (bits >= toWidth) {
                result.add((byte)(acc >> (bits -= toWidth) & (1 << toWidth) - 1));
            }
        }
        int mask = (1 << toWidth) - 1;
        if (pad) {
            if (bits > 0) {
                int partial = acc << toWidth - bits & mask;
                result.add((byte)partial);
            }
        } else if (bits == fromWidth || (acc << toWidth - bits & mask) != 0) {
            return null;
        }
        byte[] output = new byte[result.size()];
        for (int i3 = 0; i3 < output.length; ++i3) {
            output[i3] = (Byte)result.get(i3);
        }
        return output;
    }

    public static enum Encoding {
        BECH32,
        BECH32M;

    }

    public static class Bech32Data {
        public final Encoding encoding;
        public final String hrp;
        public final byte[] data;

        private Bech32Data(Encoding encoding, String hrp, byte[] data) {
            this.encoding = encoding;
            this.hrp = hrp;
            this.data = data;
        }
    }
}

